import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite, } from "cc";
import store from "../store/store";
import { observer, render } from "../store/decorators";
import { _asyncThrottle, dateFormatter } from "../Utils/Utils";
import { showPanel } from "../../Module/UIFast";
import SharePop from "./SharePop";
import { LOG_TYPE, sendLog } from "../Utils/WebNet/WebNet";

const { ccclass, property } = _decorator;

@observer
@ccclass('RankPrizePanel')
export default class RankPrizePanel extends Panel {

  static bundle = "RankPrizePanel";
  static skin = "RankPrizePanel";

  @property(Node) closeBtn: Node = null;
  @property(Node) shareBtn: Node = null;

  @property(Sprite) PrizeImg: Sprite = null;
  @property(Label) PrizeName: Label = null;
  @property(Label) PrizeTitle: Label = null;
  @property(Label) PrizeCount: Label = null;


  onLoad() {
    this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
    this.shareBtn.on(Button.EventType.CLICK, this.doShare);
  }

  async start() {

    const { data = this.data } = this.data
    this.PrizeTitle.getComponent(Label).string = `${dateFormatter(data.openDate, "MM月dd日")} ${data.rankType == 1 ? "省份榜" : "个人榜"}模式中排名${data.index}名`
    this.PrizeName.getComponent(Label).string = data.prizeName;
    this.PrizeCount.getComponent(Label).string = "x" + data.count || "1";
    this.PrizeImg.getComponent(Sprite).spriteFrame = data.prizeImage;
  }

  clickClose = () => {
    this.hidePanel();
    setTimeout(() => {
      store.judgeMedalPop()
    }, 200);
  }


  doShare = _asyncThrottle(async () => {
    sendLog(LOG_TYPE.CLICK, 16)

    this.hidePanel();
    console.log("======", this.data);
    const prizeImg = this.data.prizeImage
    const prizeName = this.data.prizeName

    await showPanel(SharePop, { prizeImg, prizeName })
  })
}
