import Panel from "../../Module/Panel";
import { _decorator, Button, instantiate, Label, Node, Prefab, Sprite } from "cc";
import { observer } from "../store/decorators";
import { changeScene, hideWaiting, showPanel, showWaiting } from "../../Module/UIFast";
import { HomeScene } from "../Scenes/HomeScene";
import GamePosterPanel from "./GamePosterPanel";
import { reBackNick } from "../Scenes/MainGame/Common/AINick";
import { LOG_TYPE, sendLog } from "../Utils/WebNet/WebNet";
import gameStore from "../store/gameStore";
import { MainGame } from "../Scenes/MainGame/MainGame";
import { _asyncThrottle } from "../Utils/Utils";

const { ccclass, property } = _decorator;

@observer
@ccclass("GameResultPanel")
export default class GameResultPanel extends Panel {

    static bundle = "GameResultPanel";
    static skin = "GameResultPanel";

    @property(Node) share: Node = null;
    @property(Node) back: Node = null;
    @property(Node) again: Node = null;
    @property(Node) prizeNode: Node = null;
    @property(Prefab) prizePrefab: Prefab = null;
    @property(Label) totalLength: Label = null;
    @property(Label) totalKill: Label = null;
    @property(Node) scroll: Node = null;
    @property(Node) noPrize: Node = null;

    onLoad() {
        reBackNick();
        this.share.on(Button.EventType.CLICK, this.clickShare, this);
        this.back.on(Button.EventType.CLICK, this.clickBack, this);
        this.again.on(Button.EventType.CLICK, this.clickAgain, this);
        sendLog(LOG_TYPE.EXPOSURE, 12)

    }

    async start() {
        const { finalKill, score, awardList } = this.data;

        this.totalKill.string = `${finalKill}`;
        this.totalLength.string = `${score}`;

        const prizeList = awardList.filter((prize) => {
            return prize.count > 0;
        });

        if (prizeList.length) {
            this.scroll.active = true;
            this.noPrize.active = false;
        } else {
            this.scroll.active = false;
            this.noPrize.active = true;
        }

        prizeList.forEach(({ count, prizeName, prizeImage }) => {
            const node = instantiate(this.prizePrefab);
            this.prizeNode.addChild(node);

            const nameStr = prizeName + (count > 1 ? ` ×${count}` : "");
            node.getChildByName("name").getComponent(Label).string = nameStr;
            node.getChildByName("img").getComponent(Sprite).spriteFrame = prizeImage;
        });

    }

    clickShare() {
        sendLog(LOG_TYPE.CLICK, 12)

        const { finalKill, score } = this.data;

        showPanel(GamePosterPanel, {
            finalKill,
            score
        });
    }

    clickBack() {
        this.hidePanel();
        changeScene(HomeScene);
    }

    clickAgain = _asyncThrottle(async () => {
        this.hidePanel();
        showWaiting();
        await gameStore.startGame();
        changeScene(MainGame);
        hideWaiting();
    });
    // @render
    // render() {
    //     const {ruleInfo = ""} = store;
    //     this.setRuleTxt(ruleInfo);
    // }

}
