import { BaseBuff } from "./BaseBuff";
import { BuffType } from "./BuffType";

// 护盾Buff
export class ShieldBuff extends BaseBuff {
    constructor(duration: number = 10) {
        super(BuffType.SHIELD, duration, 1);
    }

    protected onActivate(): void {
        this.target.setInvincible(true);
    }

    protected onDeactivate(): void {
        this.target.setInvincible(false);
    }
}

// 加速Buff
export class SpeedUpBuff extends BaseBuff {
    constructor(duration: number = 8, accPercent: number = 1.5) {
        super(BuffType.SPEED_UP, duration, accPercent);
    }

    protected onActivate(): void {
        this.target.setSpeedMultiplier(this.value);
    }

    protected onDeactivate(): void {
        this.target.setSpeedMultiplier(1);
    }
}

// 磁铁Buff
export class MagnetBuff extends BaseBuff {
    constructor(duration: number = 15, range: number = 100) {
        super(BuffType.MAGNET, duration, range);
    }

    protected onUpdate(dt: number): void {
        // 在这里实现磁铁效果的逻辑
        // 例如：吸引范围内的食物
    }
} 