import Panel from "../../Module/Panel";
import { _decorator, Button, RichText, UITransform, Node, Sprite, Texture2D, ImageAsset, SpriteFrame } from "cc";
import store from "../store/store";
import { observer, render } from "../store/decorators";

const { ccclass, property } = _decorator;

import { HTMLRichText } from "../../Component/HTMLRichText/HTMLRichText";
import { WebNetName, sendWebNet } from "../Utils/WebNet/WebNet";

@observer
@ccclass('RulePanel')
export default class RulePanel extends Panel {

  static bundle = "RulePanel";
  static skin = "RulePanel";

  @property(Node) closeBtn: Node = null;
  @property(Node) spNode: Node = null;

  async onLoad() {
    await store.updateRule()
    this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
  }

  async start() {
    // const { success, data } = await sendWebNet(WebNetName.projectRule);
    // if (!success) return

    this.setRuleTxt(store.ruleInfo);
  }

  clickClose = () => {
    this.hidePanel();
  }

  setRuleTxt(txt: string) {

    this.spNode.getComponent(HTMLRichText).html = txt;

    this.spNode.once(HTMLRichText.EventType.AFTER_RENDER, () => {

      const { width: pw, height: ph } = this.spNode.getComponent(UITransform);

      const width = this.spNode.parent.getComponent(UITransform).width;

      const height = ph * width / pw;

      this.spNode.getComponent(UITransform).setContentSize(width, height);

    });
  }
}
