import { color, mat4, misc, Node, Sprite } from "cc";

export class SvgaTrack {

	constructor(
		private node: Node,
		private frames: SVGA.VideoFrame[],
	) {
	}

    tempMat = mat4();
    tempColor = color(255, 255, 255, 255);

	/**
	 * 这里用的帧数
	 * @param time 帧小数
	 */
	setValue(time: number) {

        const {node, frames, tempColor, tempMat} = this;

        // time = time % this.frames.length;

        //处理time
        time = Math.round(misc.clampf(time, 0, frames.length - 1));

        //找对应数据
        const {alpha, transform, maskPath} = frames[time];

        // layout不晓得干嘛用，暂不管

        if (alpha < 0.05) {
            tempColor.a = 0;
            node.getComponent(Sprite).color = tempColor;
        } else {
            tempColor.a = alpha * 255;
            node.getComponent(Sprite).color = tempColor;

            const {a, b, c, d, tx, ty} = transform;

            tempMat.m00 = a;
            tempMat.m01 = b;
            tempMat.m04 = -c;
            tempMat.m05 = -d;
            tempMat.m12 = tx;
            tempMat.m13 = ty;

            node.matrix = tempMat;
        }
	}

	resetValue() {
		// @ts-ignore
        // 2.x 重置计算本地矩阵的标记，让渲染器不计算本地矩阵，不重置的话，会在刚开始的时候计算一次
        // this.node._renderFlag &= ~cc.RenderFlow.FLAG_LOCAL_TRANSFORM;

		this.setValue(0);
	}

	destroy() {
		this.node = null;
		// this.frames.length = 0;  // 不能加！！！
	}
}
