import Panel from "../../Module/Panel";
import {
    _decorator,
    Button,
    Node,
    Size,
    Label
} from "cc";

const {ccclass, property} = _decorator;

import { YXCollectionView, YXFlowLayout, YXIndexPath } from "../../Component/YXList/lib";
import { sendWebNet, WebNetName } from "../Utils/WebNet/WebNet";
import { hidePanel, hideWaiting, showWaiting } from "../../Module/UIFast";


enum TAB {
    DAILY = "DAILY",
    MONTHLY = "MONTHLY",
}

@ccclass('RankPanel')
export default class RankPanel extends Panel {

    static bundle = "RankPanel";
    static skin = "RankPanel";
    // static group = "RankPanel";

    @property(Node) listBg: Node = null;
    @property(Node) closeBtn: Node = null;

    @property(Node) daily_a: Node = null;
    @property(Node) daily_b: Node = null;
    @property(Node) monthly_a: Node = null;
    @property(Node) monthly_b: Node = null;


    @property(Node) daily: Node = null;
    @property(Node) myDaily: Node = null;
    @property(YXCollectionView) dailyList: YXCollectionView = null;
    @property(Node) dailyNoOne: Node = null;

    @property(Node) monthly: Node = null;
    @property(Node) myMonthly: Node = null;
    @property(YXCollectionView) monthlyList: YXCollectionView = null;
    @property(Node) monthlyNoOne: Node = null;

    private _tab: TAB = TAB.DAILY;
    set tab(tab: TAB) {
        this._tab = tab;
        const isDaily = tab == TAB.DAILY;
        this.daily_a.active = isDaily;
        this.daily_b.active = !isDaily;
        this.monthly_a.active = !isDaily;
        this.monthly_b.active = isDaily;
        this.listBg.setScale(isDaily ? 1 : -1, 1, 1);

        this.daily.active = isDaily;
        this.monthly.active = !isDaily;
    }

    get tab() {
        return this._tab;
    }

    dailyData: any[] = [];
    monthlyData: any[] = [];

    onLoad() {
        this.daily_b.on(Button.EventType.CLICK, this.clickDaily, this);
        this.monthly_b.on(Button.EventType.CLICK, this.clickMonthly, this);
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose, this);

        this.tab = TAB.DAILY;
    }

    async start() {
        // daily
        this.dailyList.numberOfItems = () => this.dailyData.length;
        this.dailyList.onCellDisplay = this.onDailyCellDisplay;

        const dailyLayout = new YXFlowLayout();
        dailyLayout.itemSize = new Size(480, 51);
        this.dailyList.layout = dailyLayout;
        this.dailyList.reloadData();

        // monthly
        this.monthlyList.numberOfItems = () => this.monthlyData.length;
        this.monthlyList.onCellDisplay = this.onMonthlyCellDisplay;

        const monthlyLayout = new YXFlowLayout();
        monthlyLayout.itemSize = new Size(480, 51);
        this.monthlyList.layout = monthlyLayout;
        this.monthlyList.reloadData();


        showWaiting(true);
        await Promise.all([
            this.updateDaily(),
            this.updateMonthly(),
        ]);
        hideWaiting();
        // await this.updateDaily();
        // await this.updateMonthly();
    }

    clickDaily() {
        this.tab = TAB.DAILY;
    }

    clickMonthly() {
        this.tab = TAB.MONTHLY;
    }

    async updateDaily() {
        const {success, data} = await sendWebNet(
            WebNetName.rankInfo,
            {type: "day"}
        );
        if (!success) return;
        this.dailyData = data.rankList;
        this.dailyList.reloadData();
        this.onCellDisplay(this.myDaily, data.myRank);

        this.dailyList.node.active = this.dailyData.length > 0;
        this.dailyNoOne.active = this.dailyData.length <= 0;
    }

    async updateMonthly() {
        const {success, data} = await sendWebNet(
            WebNetName.rankInfo,
            {type: "month"}
        );
        if (!success) return;

        this.monthlyData = data.rankList;
        this.monthlyList.reloadData();
        this.onCellDisplay(this.myMonthly, data.myRank);

        this.monthlyList.node.active = this.monthlyData.length > 0;
        this.monthlyNoOne.active = this.monthlyData.length <= 0;
    }

    onDailyCellDisplay = (cell: Node, indexPath: YXIndexPath, collectionView: YXCollectionView) => {
        const data = this.dailyData[indexPath.item];
        this.onCellDisplay(cell, data);
    }

    onMonthlyCellDisplay = (cell: Node, indexPath: YXIndexPath, collectionView: YXCollectionView) => {
        const data = this.monthlyData[indexPath.item];
        this.onCellDisplay(cell, data);
    }

    onCellDisplay = (cell: Node, data) => {
        let {rank, nickname, score} = data;

        for (let i = 1; i <= 4; i++) {
            cell.getChildByName(`t${i}`).active = false;
        }

        const showRank = Math.min(rank, 4);
        cell.getChildByName(`t${showRank || 4}`).active = true;

        let rankTxt = rank;
        if (!rank) {
            if (score) {
                rankTxt = "1000+";
            } else {
                rankTxt = "-";
            }
        } else {
            if (rank > 1000) {
                rankTxt = "1000+";
            }
        }
        cell.getChildByName(`t4`).getComponent(Label).string = rankTxt;

        cell.getChildByName(`name`).getComponent(Label).string = nickname || "***";
        cell.getChildByName(`score`).getComponent(Label).string = score || "0";
    }

    clickClose = () => {
        if (this.data?.from == "Game") {
        } else {
            this.hidePanel();
        }
    }

}
