import { _decorator, Component, Node, Sprite, Color } from "cc";

const { ccclass, property } = _decorator;

@ccclass("FastBtn")
export class FastBtn extends Component {
  // 是否处于加速状态
  isFash: boolean = false;

  // 按钮精灵组件
  @property(Sprite)
  sp: Sprite = null;

  // 按钮颜色状态
  private c1 = new Color(255, 255, 255, 220); // 按下时的颜色
  private c2 = new Color(200, 200, 200, 200); // 松开时的颜色

  onLoad() {
    // 注册触摸事件
    this.node.on(Node.EventType.TOUCH_START, this.OnTouchStart, this);
    this.node.on(Node.EventType.TOUCH_END, this.OnTouchEnd, this);
    this.node.on(Node.EventType.TOUCH_CANCEL, this.OnTouchEnd, this);
  }

  // 按下时的处理
  OnTouchStart() {
    this.isFash = true;
    this.sp.color = this.c1;
  }

  // 松开时的处理
  OnTouchEnd() {
    this.isFash = false;
    this.sp.color = this.c2;
  }
}