// 事件名称定义
import { ccenum } from "cc";

export const Events = {
  changeSkinId: "changeSkinId",   // 更换皮肤事件
  setGameState: "setGameState",    // 设置游戏状态事件
  showGOver: "showGOver"          // 显示游戏结束界面事件
}

// 食物类型枚举
export enum FoodType {
  FOOD = 0,   // 普通食物
  MONEY = 1   // 金币
}
ccenum(FoodType)


// 移动方向枚举
export enum DirectionType {
  DEFAULT = 0,  // 默认方向
  LEFT = 1,     // 向左
  RIGHT = 2     // 向右
}

// 游戏状态枚举
export enum GameState {
  READY = 0,   // 准备状态
  PLAY = 1,    // 游戏中
  PAUSE = 2,   // 暂停
  OVER = 3,    // 游戏结束
  WIN = 4,     // 游戏胜利
  QUIT = 5     // 退出游戏
}