import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite } from "cc";
import { observer } from "../store/decorators";
import { changeScene } from "../../Module/UIFast";
import { HomeScene } from "../Scenes/HomeScene";

const { ccclass, property } = _decorator;

@observer
@ccclass("GameFailPanel")
export default class GameFailPanel extends Panel {

    static bundle = "GameFailPanel";
    static skin = "GameFailPanel";

    @property(Node) back: Node = null;

    onLoad() {
        this.back.on(Button.EventType.CLICK, this.clickBack, this);
    }

    async start() {
    }

    clickBack() {
        this.hidePanel();
        changeScene(HomeScene);
    }

    // @render
    // render() {
    //     const {ruleInfo = ""} = store;
    //     this.setRuleTxt(ruleInfo);
    // }

}
