import { _decorator, Component } from "cc";
import { foodPool } from "../Manager/CommonPool";

const { ccclass, property } = _decorator;

@ccclass("Food")
export class Food extends Component {

    _energy: number = 1;

    @property
    get energy() {
        return this._energy;
    }

    set energy(energy: number) {
        this._energy = energy;
        const scale = 1 + (energy - 1) / 3;
        this.node.scale.set(scale, scale);
    }

    init(energy: number = 1) {
        this.energy = energy;
    }

    protected start() {

    }

    recycle() {
        this.node.removeFromParent();
        foodPool.put(this.node);
    }

}