import { _decorator, View } from 'cc';
const { ccclass } = _decorator;

/**
 * 全局配置类
 */
@ccclass('Global')
export class Global {

  /** 设计分辨率 */
  public static designResolutionSize = View.instance.getDesignResolutionSize();

  /** 可视区域大小 */
  public static visibleSize = View.instance.getVisibleSize();

  /** 宽度缩放比例 */
  public static widthScaling = Math.round(
    (Global.visibleSize.width / Global.designResolutionSize.width) * 100
  ) / 100;

  /** 地图宽度 */
  public static MAP_WIDTH: number = 6000;

  /** 地图高度 */
  public static MAP_HEIGHT: number = 4200;

}