import { _decorator, Button, instantiate, Label, Node, Prefab, Sprite } from "cc";
import Scene from "db://assets/Module/Scene";
import { changeScene, showPanel, showToast } from "db://assets/Module/UIFast";
import store from "../store/store";
import { observer, render } from "../store/decorators";
import ProPop from "db://assets/Scripts/Panels/ProPop";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import { PointDetailScene } from "db://assets/Scripts/Scenes/PointDetailScene";


const { ccclass, property } = _decorator;

@observer
@ccclass("PropPage")
export class PropPage extends Scene {

    static bundle: string = "PropPage";
    static skin: string = "PropPage";

    @property(Node) backBtn: Node = null;
    @property(Label) credits: Label = null;
    @property(Prefab) prizePrefab: Prefab = null;
    @property(Node) content: Node = null;
    @property(Node) point: Node = null;

    onLoad() {
        this.backBtn.on(Button.EventType.CLICK, this.clickToBack, this);
        this.point.on(Button.EventType.CLICK, this.clickToChange, this);
    }

    async start() {
        await store.getExchangeInfo();
        this.updateInfo();
    }

    @render
    render() {
        const { remainCredits } = store.exchangeInfo;
        this.credits.string = `${remainCredits}`;
    }

    updateInfo() {
        const { exchangeShopList } = store.exchangeInfo;

        exchangeShopList.forEach((item, index) => {

            const {
                id,
                optionName,
                optionImg,
                spDetail,
                prizeId,
                userLimitCount,
                alreadyUserCount,
                consumeCreditsNum,
            } = item;

            const prize = instantiate(this.prizePrefab);
            this.content.addChild(prize);

            prize.getChildByName("prizeName")
                .getComponent(Label).string = optionName;

            prize.getChildByName("prize")
                .getComponent(Sprite).spriteFrame = optionImg;

            prize.getChildByName("explain")
                .getComponent(Label).string = spDetail;

            const btn = prize.getChildByName("btn");
            btn.getChildByName("num2")
                .getComponent(Label).string = consumeCreditsNum;

            btn.on(Button.EventType.CLICK, () => this.clickToConfirm(item));
        });
    }

    /** 点击积分按钮*/
    clickToChange() {
        changeScene(PointDetailScene, { ifFrom: PropPage, back: this.data.isFrom });
    }

    /** 点击返回按钮*/
    clickToBack = async () => {
        const { isFrom, isPop } = this.data;
        if (isPop == true) {
            changeScene(HomeScene);
            showPanel(isFrom, { tab: "TOOL" });
        } else {
            changeScene(isFrom);
        }
    };

    clickToConfirm = async (item) => {
        const { consumeCreditsNum, } = item;

        if (store.exchangeInfo.remainCredits < consumeCreditsNum) {
            showToast("积分数量不足");
        } else {
            showPanel(ProPop, item);
        }

    };
}