import { Button, Component, Node } from "cc";

export default class Module extends Component {
    static bundle: string = "";
    static skin: string = "";
    static group: string | string[] = null;

    data: any = {};

    btnEnable(btn: Node | Button, enable) {
        if (btn instanceof Node) {
            btn = btn.getComponent(Button);
        }
        if (!btn) return;
        btn.interactable = enable;
    }

    btnDelay(btn: Node | Button, time) {
        if (btn instanceof Node) {
            btn = btn.getComponent(Button);
        }
        if (!btn) return;
        this.scheduleOnce(() => {
            (btn as Button).interactable = true;
        }, time);
    }
}
