import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite, } from "cc";
import store from "../store/store";
import { observer, render } from "../store/decorators";
import { sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { _asyncThrottle } from "../Utils/Utils";

const { ccclass, property } = _decorator;

@observer
@ccclass('SnakeSkin')
export default class SnakeSkin extends Panel {

  static bundle = "SnakeSkin";
  static skin = "SnakeSkin";

  @property(Node) closeBtn: Node = null;
  @property(Node) dressBtn: Node = null;


  onLoad() {
    this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
    this.dressBtn.on(Button.EventType.CLICK, this.clickDress);
  }

  async start() {
  }

  clickClose = () => {
    this.hidePanel();
  }

  clickDress = _asyncThrottle(async () => {
    const { success, data } = await sendWebNetWithToken(WebNetName.doDress, { spId: "sp_skin_snake_year" });
    if (!success) return;

    console.log("换上了新皮肤");
    this.hidePanel()
  })
}
