import mobx from "mobx";
import {sendWebNet, sendWebNetWithToken, WebNetName} from "../Utils/WebNet/WebNet";
import {showPanel} from "../../Module/UIFast";
import RankPrizePanel from "../Panels/RankPrizePanel";
import {getUrlParams} from "../Utils/WebNet/web/webTools";
import {assetManager, ImageAsset, SpriteFrame, Texture2D} from "cc";
import GetPrize from "db://assets/Scripts/Panels/GetPrize";

const {makeAutoObservable} = mobx;


export interface IHomeInfo {
    actStartTime: number;
    actEndTime: number;
    currentTime: number;
    creditsNum: number;
    signPopFlag: boolean;
    continueSignDays: number;
    nickname: string;
    avatar: string;
    newGetSpId: string;
    newGetSpName: string;
    newGetSpImage: string;
    luckBenefitDesc: string;
    rankInfos: {
        index: number;
        nickname: string;
        avatar: string;
    }[];
    rankPopList: {
        rankType: 1 | 2;
        openDate: string;
        index: number;
        prizeId: string;
        prizeName: string;
        prizeImage: string;
        count: number;
    }[];
    bagPopVO: {
        bagNum: number;
        bagName: string;
        bagImg: number;
    };
}


class Store {

    frontVariable: { [key in string]: any } = {}

    async updateFrontVariable() {
        const {success, data} = await sendWebNet(WebNetName.getFrontVariable);
        if (!success) {
            return;
        }
        this.frontVariable = data;
    }

    homeInfo: IHomeInfo = {
        actStartTime: Date.now(),
        actEndTime: Date.now() - 1000,
        currentTime: Date.now(),
        creditsNum: 0,
        signPopFlag: false,
        continueSignDays: 0,
        nickname: "",
        avatar: "",
        newGetSpName: "",
        newGetSpImage: "",
        luckBenefitDesc: "",
        newGetSpId: null,
        rankInfos: [],
        rankPopList: [],
        bagPopVO: null,
    }

    async updateIndex() {
        const {success, data} = await sendWebNet(WebNetName.index);
        if (!success) {
            return;
        }

        this.homeInfo = data;

        if (data.bagPopVO) {
            showPanel(GetPrize, [{

                   data: data.bagPopVO,
                prizeName: data.bagPopVO.bagName,
                prizeImg: data.bagPopVO.bagImg

            }])
        }
    }

    ruleInfo: string = "";

    async updateRule() {
        const {success, data} = await sendWebNet(WebNetName.projectRule);
        if (!success) {
            return;
        }
        this.ruleInfo = data;
    }

    medalPop: any[] = [];

    setRankPop() {
        this.medalPop = this.homeInfo.rankPopList;
        this.judgeMedalPop();
    }

    judgeMedalPop() {
        if (this.medalPop.length > 0) {
            const item = this.medalPop.pop()

            console.log("准备跳转了", item);
            showPanel(RankPrizePanel, item);

        }
    }

    // // 道具页接口
    // propPageInfo: {}
    //
    // async getPropPageInfo(credits: string) {
    //     const param = {
    //         credits,
    //     };
    //     const {success, data} = await sendWebNet(WebNetName.propPag,param);
    //     if (!success) {
    //         return;
    //     }
    //     this.propPageInfo = data
    //
    // }

    async doAssist() {
        const inviteCode = getUrlParams("inviteCode");
        if (!inviteCode) return;

        const {success} = await sendWebNetWithToken(WebNetName.doAssist, {inviteCode});

    }


    async getTaskInfo() {
        return await sendWebNetWithToken(WebNetName.taskList, {
            taskToken: getUrlParams("taskToken") || "123456",
        });
    }

}


const store: Store = makeAutoObservable(new Store());

export default store;