import Panel from "../../Module/Panel";
import {_decorator, Button, RichText, UITransform, Node, Sprite, Texture2D, ImageAsset, SpriteFrame} from "cc";
import {observer, render} from "../store/decorators";
import {hidePanel, showPanel} from "db://assets/Module/UIFast";
import {sendWebNetWithToken, WebNetName} from "db://assets/Scripts/Utils/WebNet/WebNet";
import ExchangeSuccess from "db://assets/Scripts/Panels/ExchangeSuccess";
import GetPrize from "db://assets/Scripts/Panels/GetPrize";

const {ccclass, property} = _decorator;

@observer
@ccclass('openGoldPop')
export default class openGoldPop extends Panel {

    static bundle = "openGoldPop";
    static skin = "openGoldPop";

    @property(Node) composedOneGold: Node = null;
    @property(Node) composedFiveGold: Node = null;
    @property(Node) x5: Node = null;
    @property(Node) goldThink: Node = null;

    onLoad() {
        this.composedOneGold.on(Button.EventType.CLICK, this.clickOneGold);
        this.composedFiveGold.on(Button.EventType.CLICK, this.clickFiveGold);
        this.goldThink.on(Button.EventType.CLICK, this.clickThink);
    }

    start() {
        const {data = this.data} = this.data
        if (data == 1) {
            this.x5.active = false
            this.composedOneGold.active = true
            this.composedFiveGold.active = false
        } else if (data == 5) {
            this.x5.active = true
            this.composedOneGold.active = false
            this.composedFiveGold.active = true
        }
    }

    async clickThink() {
        hidePanel()
    }

    async clickOneGold() {
        const {success, data} = await sendWebNetWithToken(WebNetName.bagExchange, {drawType: 2, drawCount: 1})
        if (!success) return

        hidePanel()
        await showPanel(GetPrize, data.prizeVOList)
    }

    async clickFiveGold() {
        const {success, data} = await sendWebNetWithToken(WebNetName.bagExchange, {drawType: 2, drawCount: 5})
        if (!success) return

        hidePanel()
        await showPanel(GetPrize, data.prizeVOList)
    }

}
