import Panel from "../../Module/Panel";
import {
    _decorator,
    Button,
    Node,
    Sprite,
    Label,
    Prefab, instantiate
} from "cc";
import {observer, render} from "../store/decorators";
import {showPanel} from "db://assets/Module/UIFast";
import SharePop from "db://assets/Scripts/Panels/SharePop";

const {ccclass, property} = _decorator;

@observer
@ccclass('GetPrize')
export default class GetPrize extends Panel {

    static bundle = "GetPrize";
    static skin = "GetPrize";

    @property(Node) share: Node = null;
    @property(Node) happy: Node = null;
    @property(Prefab) prizePrefab: Prefab = null;

    @property(Node) content: Node = null;

    onLoad() {
        this.happy.on(Button.EventType.CLICK, this.clickHappy);
        this.share.on(Button.EventType.CLICK, this.clickShare);
    }

    async start() {

        const {data = this.data} = this.data

        data.map((item, index) => {
            const prize = instantiate(this.prizePrefab)
            this.content.addChild(prize)

            const prizeName = prize.getChildByName("Label")
            prizeName.getComponent(Label).string = item.prizeName
            prize.getComponent(Sprite).spriteFrame = item.prizeImg
        })
    }

    clickShare() {
        showPanel(SharePop, {
            prizeName: this.data[0].prizeName,
            prizeImg: this.data[0].prizeImg,
        })
    }

    clickHappy = () => {
        this.hidePanel()
    }

}
