import Panel from "../../Module/Panel";
import {_decorator, Button, RichText, UITransform, Node, Sprite, Texture2D, ImageAsset, SpriteFrame} from "cc";
import {observer, render} from "../store/decorators";
import {hidePanel, showPanel} from "db://assets/Module/UIFast";
import {sendWebNetWithToken, WebNetName} from "db://assets/Scripts/Utils/WebNet/WebNet";
import ExchangeSuccess from "db://assets/Scripts/Panels/ExchangeSuccess";
import GetPrize from "db://assets/Scripts/Panels/GetPrize";

const {ccclass, property} = _decorator;

@observer
@ccclass('openDiamondPop')
export default class openDiamondPop extends Panel {

    static bundle = "openDiamondPop";
    static skin = "openDiamondPop";

    @property(Node) composedOneDiamond: Node = null;
    @property(Node) composedFiveDiamond: Node = null;
    @property(Node) x5: Node = null;
    @property(Node) diamondThink: Node = null;


    onLoad() {
        this.composedOneDiamond.on(Button.EventType.CLICK, this.clickOneDiamond);
        this.composedFiveDiamond.on(Button.EventType.CLICK, this.clickFiveDiamond);
        this.diamondThink.on(Button.EventType.CLICK, this.clickThink);
    }

    start() {
        const {data = this.data} = this.data
        console.log(data)
        if (data == 1) {
            this.x5.active = false
            this.composedOneDiamond.active = true
            this.composedFiveDiamond.active = false
        } else if (data == 5) {
            this.x5.active = true
            this.composedOneDiamond.active = false
            this.composedFiveDiamond.active = true
        }
    }

    async clickThink() {
        hidePanel()
    }

    async clickOneDiamond() {
        const {success, data} = await sendWebNetWithToken(WebNetName.bagExchange, {drawType: 3, drawCount: 1})
        if (!success) return

        hidePanel()
        await showPanel(GetPrize, data.prizeVOList)

    }

    async clickFiveDiamond() {
        const {success, data} = await sendWebNetWithToken(WebNetName.bagExchange, {drawType: 3, drawCount: 5})
        if (!success) return

        hidePanel()
        await showPanel(GetPrize, data.prizeVOList)

    }
}
