import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite, } from "cc";
import store from "../store/store";
import { observer, render } from "../store/decorators";

const { ccclass, property } = _decorator;

@observer
@ccclass('RankPrizePanel')
export default class RankPrizePanel extends Panel {

  static bundle = "RankPrizePanel";
  static skin = "RankPrizePanel";

  @property(Node) closeBtn: Node = null;
  @property(Node) shareBtn: Node = null;

  @property(Sprite) PrizeImg: Sprite = null;
  @property(Label) PrizeName: Label = null;
  @property(Label) PrizeTitle: Label = null;

  onLoad() {
    this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
  }

  async start() {

    const { data = this.data } = this.data
    console.log("看看这里拿到了什么数", data);
    this.PrizeTitle.getComponent(Label).string = `${data.openDate} ${data.rankType == 1 ? "省份榜" : "个人榜"}模式中排名${data.index}名`
    this.PrizeName.getComponent(Label).string = data.prizeName;
    this.PrizeImg.getComponent(Sprite).spriteFrame = data.prizeImage;
  }

  clickClose = () => {
    this.hidePanel();
    setTimeout(() => {
      store.judgeMedalPop()
    }, 200);
  }
}
