import { _decorator, Button, Label, Node, Sprite, SpriteFrame } from "cc";
import Scene from "db://assets/Module/Scene";
import { MainGame } from "./MainGame/MainGame";
import { changeScene, hidePanel, hideWaiting, showPanel, showToast, showWaiting } from "db://assets/Module/UIFast";
import store from "../store/store";
import { observer, render } from "../store/decorators";
import { _asyncThrottle, strFormat } from "../Utils/Utils";
import { UIMgr } from "../../Module/UIMgr";
import gameStore from "../store/gameStore";
import GameResultPanel from "../Panels/GameResultPanel";
import GamePosterPanel from "../Panels/GamePosterPanel";
import ExchangeSuccess from "db://assets/Scripts/Panels/ExchangeSuccess";
import { RankScence } from "./RankScene";
import { BlessingBagPage } from "db://assets/Scripts/Scenes/BlessingBagPage";
import { PropPage } from "db://assets/Scripts/Scenes/PropPage";
import { AudioMgr } from "../../core_tgx/base/AudioMgr";
import SignPanel from "../Panels/SignPanel";
import { PointDetailScene } from "./PointDetailScene";
import { MyBagPanel } from "../Panels/MyBagPanel";
import RulePanel from "../Panels/RulePanel";
import RankPrizePanel from "../Panels/RankPrizePanel";
import SnakeSkin from "../Panels/SnakeSkin";
import shareStore from "../store/shareStore";
import { LOG_TYPE, sendLog, sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { getUrlParams } from "../Utils/WebNet/web/webTools";
import FirstSkinPanel from "../Panels/FirstSkinPanel";
import { isType1 } from "../AppTool";

const { ccclass, property } = _decorator;

@observer
@ccclass("HomeScene")
export class HomeScene extends Scene {

    static bundle: string = "HomeScene";
    static skin: string = "HomeScene";
    // static group: string[] = ["HomeScene"];


    @property(Node) startBtn: Node = null;
    @property(Node) ruleBtn: Node = null;
    @property(Node) rankBtn: Node = null;
    @property(Node) rankInfo1: Node = null;
    @property(Node) rankInfo2: Node = null;
    @property(Node) rankInfo3: Node = null;
    @property(Node) rankNone: Node = null;
    @property(Node) rankList: Node = null;
    @property(Node) blessBagBtn: Node = null;
    @property(Node) PropBtn: Node = null;
    @property(Node) signBtn: Node = null;
    @property(Node) pointBtn: Node = null;
    @property(Node) bagBtn: Node = null;
    @property(Node) shareBtn: Node = null;
    @property(Node) shareNode: Node = null;

    @property(Node) userInfo: Node = null;

    @property(Label) userName: Label;
    @property(Label) pointNum: Label;
    @property(Label) fuDaiText: Label;
    @property(Label) quanyiText: Label;
    @property(Label) signTxt: Label;

    @property(Sprite) userImg: Sprite;

    @property(SpriteFrame) bagSpNoActive: SpriteFrame;
    @property(SpriteFrame) bagSpActive: SpriteFrame;

    @property(Node) avatarTip: Node = null;

    // 默认头像
    avatar = isType1()
        ? "https://yun.duiba.com.cn/polaris/img.546cbcd3811aa2265e50d495c078108a217450b7.png"
        : "https://yun.duiba.com.cn/polaris/%E9%BB%84%E8%89%B2user_img.7a7a3f11540b4fdb4645860ec3517c31564804bb.png";

    onLoad() {
        this.startBtn.on(Button.EventType.CLICK, this.clickStart, this);
        this.ruleBtn.on(Button.EventType.CLICK, this.clickRule, this);
        this.rankBtn.on(Button.EventType.CLICK, this.clickRank, this);
        this.rankNone.on(Button.EventType.CLICK, this.clickRank, this);
        this.blessBagBtn.on(Button.EventType.CLICK, this.clickBag, this);
        this.PropBtn.on(Button.EventType.CLICK, this.clickProp, this);
        this.signBtn.on(Button.EventType.CLICK, this.clickSign, this);
        this.pointBtn.on(Button.EventType.CLICK, this.clickDetail, this);
        this.bagBtn.on(Button.EventType.CLICK, this.clickMyBag, this);
        this.shareBtn.on(Button.EventType.CLICK, this.clickShare, this);
        this.userInfo.on(Button.EventType.CLICK, this.clickUserInfo, this);
    }

    async start() {
        if (store.enter == false) {
            store.doAssist();
        }


        showWaiting();
        await store.getTaskInfo();
        await store.updateIndex();
        hideWaiting();

        sendLog(LOG_TYPE.EXPOSURE, 1);
        const {
            signPopFlag,
            rankPopList,
            newGetSpId,
            newGetSpImage,
            newGetSpName,
            firstEntryFlag,
            benefitDesc
        } = store.homeInfo || {};

        this.shareNode.active = benefitDesc != "";

        if (signPopFlag) { // 签到弹窗
            showPanel(SignPanel);
        }
        if (rankPopList.length > 0) { // 排行榜开奖弹窗
            // showPanel(RankPrizePanel);
            store.setRankPop();
        }

        if (newGetSpId == "sp_skin_snake_year") {
            showPanel(SnakeSkin, { newGetSpImage, newGetSpName });
        }

        if (firstEntryFlag) {
            showPanel(FirstSkinPanel);
        }
        UIMgr.ins.preloadScene(MainGame);
    }

    @render
    render() {
        const {
            nickname = "",
            creditsNum = 0,
            rankInfos = [],
            continueSignDays = 0,
            luckBenefitDesc = "",
            benefitDesc = "",
            avatar,
            bagLightFlag,
            bagSwitch,
            avatarGuide,
        } = store.homeInfo || {};

        this.userName.string = strFormat(nickname || "微信用户", 8);
        this.pointNum.string = `${creditsNum > 999999 ? "999999+" : creditsNum}`;
        this.userImg.spriteFrame = avatar || this.avatar;
        this.signTxt.string = `连续签到${continueSignDays || 0}天`;
        this.fuDaiText.string = luckBenefitDesc;
        this.quanyiText.string = benefitDesc;

        this.avatarTip.active = avatarGuide;

        this.bagBtn.getComponent(Sprite).spriteFrame = bagLightFlag ? this.bagSpActive : this.bagSpNoActive;

        if (rankInfos && rankInfos.length > 0) {
            this.rankList.active = true;
            this.rankNone.active = false;
            rankInfos.map((item, index) => {
                const node = this[`rankInfo${index + 1}`];

                node.active = true;
                node.getChildByPath("mask/rank_img").getComponent(Sprite).spriteFrame = item.avatar || this.avatar;
                node.getChildByName("rank_name").getComponent(Label).string = strFormat(item.nickname || "微信用户", 8);
            });
        } else {
            this.rankList.active = false;
            this.rankNone.active = true;
        }
    }


    clickStart = _asyncThrottle(async () => {
        sendLog(LOG_TYPE.CLICK, 5);
        if (!store.checkActTime()) return;

        await gameStore.startGame();
        changeScene(MainGame);

    });

    clickRule = _asyncThrottle(async () => {
        if (!store.checkActTime(true)) return;

        showPanel(RulePanel);
    });

    clickRank = _asyncThrottle(async () => {
        sendLog(LOG_TYPE.CLICK, 4);
        if (!store.checkActTime()) return;

        await changeScene(RankScence);
    });

    clickBag = _asyncThrottle(async () => {
        sendLog(LOG_TYPE.CLICK, 6);
        if (!store.checkActTime()) return;
        if(!store.homeInfo.bagSwitch) {
            showToast("暂未开启");
            return;
        }
        await changeScene(BlessingBagPage);
    });

    clickSign = _asyncThrottle(async () => {
        sendLog(LOG_TYPE.CLICK, 8);
        if (!store.checkActTime()) return;
        showPanel(SignPanel);
    });

    clickMyBag = _asyncThrottle(async () => {
        if (!store.checkActTime(true)) return;
        store.homeInfo.bagLightFlag = false;
        showPanel(MyBagPanel);
    });

    clickProp = _asyncThrottle(async () => {
        sendLog(LOG_TYPE.CLICK, 7);
        if (!store.checkActTime()) return;

        await changeScene(PropPage, { isFrom: HomeScene, isPop: false });
    });

    clickDetail = _asyncThrottle(async () => {
        if (!store.checkActTime()) return;
        await changeScene(PointDetailScene, { ifFrom: HomeScene });
    });

    clickShare = _asyncThrottle(async () => {
        sendLog(LOG_TYPE.CLICK, 2);
        if (!store.checkActTime()) return;

        shareStore.doShare(true);
    });

    clickUserInfo = _asyncThrottle(async () => {
        if (store.homeInfo.avatarGuide) {
            sendWebNet(WebNetName.avatarGuide, null, {
                hideMsg: true,
            });
            store.homeInfo.avatarGuide = false;
        }
        // @ts-ignore
        wx.miniProgram.navigateTo({
            url: "/package/pages/user-info/index",
            success: (res) => {
                console.log("成功", res);
            },
            fail: (res) => {
                console.log("失败", res);
            }
        });
    });
}

