import Panel from "../../Module/Panel";
import { _decorator, Button, Node, Sprite, Label, math } from "cc";
import { observer } from "../store/decorators";
import { showPanel, showToast } from "db://assets/Module/UIFast";
import ExchangeSuccess from "db://assets/Scripts/Panels/ExchangeSuccess";
import { creditsCost, sendWebNetWithToken, WebNetName } from "db://assets/Scripts/Utils/WebNet/WebNet";
import { _asyncThrottle } from "../Utils/Utils";
import store from "../store/store";

const { ccclass, property } = _decorator;

@observer
@ccclass("ProPop")
export default class ProPop extends Panel {

    static bundle = "PropPop";
    static skin = "PropPop";

    @property(Label) prizeName: Label = null;
    @property(Node) closeBtn: Node = null;
    @property(Node) btn: Node = null;
    @property(Sprite) prize: Sprite = null;
    @property(Label) explanation: Label = null;
    @property(Label) num: Label = null;

    @property(Node) add: Node = null;
    @property(Node) sub: Node = null;
    @property(Label) numTxt: Label = null;

    private _buyNum: number = 1;
    get buyNum() {
        return this._buyNum;
    }

    set buyNum(val) {
        const max = Math.min(~~(store.exchangeInfo.remainCredits / +this.data.consumeCreditsNum), 99);
        val = math.clamp(1, max, val);
        this._buyNum = val;
        this.numTxt.string = `${val}`;
        this.num.string = `${(+this.data.consumeCreditsNum) * val}`;
    }

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
        this.btn.on(Button.EventType.CLICK, this.clickExchange);
        this.add.on(Node.EventType.TOUCH_START, this.startAdd);
        this.add.on(Node.EventType.TOUCH_END, this.endAdd);
        this.add.on(Node.EventType.TOUCH_CANCEL, this.endAdd);

        this.sub.on(Node.EventType.TOUCH_START, this.startSub);
        this.sub.on(Node.EventType.TOUCH_END, this.endSub);
        this.sub.on(Node.EventType.TOUCH_CANCEL, this.endSub);
    }

    start() {
        const {
            id,
            optionName,
            optionImg,
            spDetail,
            prizeId,
            userLimitCount,
            alreadyUserCount,
            consumeCreditsNum
        } = this.data;

        this.explanation.string = spDetail;

        const num = this.btn.getChildByName("num");
        num.getComponent(Label).string = consumeCreditsNum;

        this.prize.spriteFrame = optionImg;

        this.prizeName.string = optionName;
    }

    startAdd = () => {
        this.buyNum++;
        this.schedule(this.scheduleAdd, 0.05, 100, 1);
    };

    scheduleAdd = () => {
        this.buyNum++;
    }

    endAdd = () => {
        this.unschedule(this.scheduleAdd);
    };

    startSub = () => {
        this.buyNum--;
        this.schedule(this.scheduleSub, 0.05, 100, 1);
    };

    scheduleSub = () => {
        this.buyNum--;
    }

    endSub = () => {
        this.unschedule(this.scheduleSub);
    }

    clickClose = () => {
        this.hidePanel();
    };

    clickExchange = _asyncThrottle(async () => {
        const {
            id,
            optionName,
            optionImg,
            spDetail,
            prizeId,
            userLimitCount,
            alreadyUserCount,
            consumeCreditsNum
        } = this.data;

        if((+consumeCreditsNum) * this.buyNum > store.exchangeInfo.remainCredits){
            return showToast("积分数量不足");
        }

        const {
            success: costSuc,
            ticket
        } = await creditsCost("exchange", "exchangeSp", `sp_deduct_desc`, (+consumeCreditsNum) * this.buyNum);

        if (!costSuc) {
            showToast("网络异常，请稍后重试～");
            return;
        }

        //兑换接口
        const { success, data } = await sendWebNetWithToken(WebNetName.propExchange, {
            id,
            ticketNum: ticket,
            num: this.buyNum,
            // ruId: item.ruleId,
        });

        if (!success) return;

        // if (conditionsItem.credits >= consumeSp.quantity) {

        showPanel(ExchangeSuccess, { ...this.data, num: this.buyNum });
        this.hidePanel();
        // }
    });
}
