import { _decorator, IVec2Like, math, View } from "cc";

const { ccclass } = _decorator;

/**
 * 全局配置类
 */
@ccclass("Global")
export class Global {

    /** 地图宽度 */
    static MAP_WIDTH: number = 6000;
    static HALF_MAP_WIDTH: number = Global.MAP_WIDTH * 0.5;

    /** 地图高度 */
    static MAP_HEIGHT: number = 4200;
    static HALF_MAP_HEIGHT: number = Global.MAP_HEIGHT * 0.5;

    /** 道具CD */
    static PROP_CD: number = 3;


    /** 防御道具持续时间 */
    static PROP_SHIELD_DUR_TIME: number = 10;
    /** 破防无敌时间 */
    static PROP_SHIELD_INVINCIBLE_TIME: number = 3;

    /** 加速道具持续时间 */
    static PROP_SPEED_DUR_TIME: number = 10;

    /** 磁吸道具持续时间 */
    static PROP_MAGNET_DUR_TIME: number = 10;
    /** 磁吸吸取半径 */
    static PROP_MAGNET_RADIUS: number = 200;

    /** 加长道具增加能量值百分比 */
    static PROP_ADD_LENGTH: number = .1;


    /** 双倍经验持续时间 */
    static PROP_DOUBLE_EXP_DUR_TIME: number = 10;


    static getRandomPosition(padding: number = 0): IVec2Like {
        const maxW = Global.HALF_MAP_WIDTH - padding;
        const maxH = Global.HALF_MAP_HEIGHT - padding;

        const x = math.randomRange(-maxW, maxW);
        const y = math.randomRange(-maxH, maxH);

        return { x, y };
    }

    static stageConfig = [
        {
            time: 10,
        },
        {
            time: 60,
            energy: 200,
        }
    ];

}


export const SkinName = {
    "sp_decoration_default": "default",
    "sp_skin_snake_year": "newYear2025",
};
