import mobx from "mobx";
import { sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { showPanel } from "../../Module/UIFast";
import RankPrizePanel from "../Panels/RankPrizePanel";
import { getUrlParams } from "../Utils/WebNet/web/webTools";
import { assetManager, ImageAsset, SpriteFrame, Texture2D } from "cc";

const {makeAutoObservable} = mobx;


export interface IHomeInfo {
    actStartTime: number;
    actEndTime: number;
    currentTime: number;
    creditsNum: number;
    signPopFlag: boolean;
    continueSignDays: number;
    nickname: string;
    avatar: string;
    newGetSpId: string;
    rankInfos: {
        index: number;
        nickname: string;
        avatar: string;
    }[];
    rankPopList: {
        rankType: 1 | 2;
        openDate: string;
        index: number;
        prizeId: string;
        prizeName: string;
        prizeImage: string;
        count: number;
    }[];
    bagPopVO: {
        bagNum: number;
        bagName: string;
        bagImg: number;
    };
}


class Store {

    frontVariable: { [key in string]: any } = {}

    async updateFrontVariable() {
        const {success, data} = await sendWebNet(WebNetName.getFrontVariable);
        if (!success) {
            return;
        }
        this.frontVariable = data;
    }

    homeInfo: IHomeInfo = {
        actStartTime: Date.now(),
        actEndTime: Date.now() - 1000,
        currentTime: Date.now(),
        creditsNum: 0,
        signPopFlag: false,
        continueSignDays: 0,
        nickname: "",
        avatar: "",
        newGetSpId: null,
        rankInfos: [],
        rankPopList: [],
        bagPopVO: null,
    }

    async updateIndex() {
        const {success, data} = await sendWebNet(WebNetName.index);
        if (!success) {
            return;
        }

        this.homeInfo = data;
    }

    ruleInfo: string = "";

    async updateRule() {
        const {success, data} = await sendWebNet(WebNetName.projectRule);
        if (!success) {
            return;
        }
        this.ruleInfo = data;
    }

    medalPop: any[] = [];

    setRankPop() {
        this.medalPop = this.homeInfo.rankPopList;
        this.judgeMedalPop();
    }

    judgeMedalPop() {
        if (this.medalPop.length > 0) {
            const item = this.medalPop.pop()

            console.log("准备跳转了", item);
            showPanel(RankPrizePanel, item);

        }
    }


    inviteInfo: {
        shareUrl: string,
        inviteCode: string,
        qrCode: string | SpriteFrame,
    } = {
        shareUrl: "",
        inviteCode: "",
        qrCode: "",
    };

    async genInviteInfo() {

        this.inviteInfo.shareUrl = `${location.origin}${location.pathname}`
            + `?appID=${getUrlParams("appID")}`;

        const { success: genCodeSuc, data: genCodeData } = await sendWebNet(WebNetName.getInviteCode);
        if (!genCodeSuc) {
            this.inviteInfo.inviteCode = genCodeData.inviteCode;
        }

        this.inviteInfo.shareUrl = `${location.origin}${location.pathname}`
            + `?appID=${getUrlParams("appID")}`
            + `&inviteCode=${genCodeData.inviteCode}`;

        const path = "package/pages/common-activity/index" +
            "?webUrl=" + encodeURIComponent(this.inviteInfo.shareUrl);

        const { success: genQrSuc, data: genQrData } = await sendWebNet(WebNetName.genQrCode, {
            path: path,
        });

        if (genQrSuc) {
            this.inviteInfo.qrCode = genQrData.result;
            assetManager.loadRemote<Texture2D>(genQrData.result, (err, imageAsset: ImageAsset) => {
                if (err) {
                    return;
                }
                const texture = new Texture2D();
                texture.image = imageAsset;
                const sp = new SpriteFrame();
                sp.texture = texture;
                this.inviteInfo.qrCode = sp;
            });
        }
    }


    // // 道具页接口
    // propPageInfo: {}
    //
    // async getPropPageInfo(credits: string) {
    //     const param = {
    //         credits,
    //     };
    //     const {success, data} = await sendWebNet(WebNetName.propPag,param);
    //     if (!success) {
    //         return;
    //     }
    //     this.propPageInfo = data
    //
    // }

    async doAssist() {
        const {
            success
            } = await sendWebNetWithToken(WebNetName.doAssist)

    }

}

const store: Store = makeAutoObservable(new Store());

export default store;