import Panel from "../../Module/Panel";
import {_decorator, Button, Node, Sprite, Label} from "cc";
import {observer} from "../store/decorators";
import {hidePanel, showPanel} from "db://assets/Module/UIFast";
import {sendWebNetWithToken, WebNetName} from "db://assets/Scripts/Utils/WebNet/WebNet";
import GetPrize from "db://assets/Scripts/Panels/GetPrize";

const {ccclass, property} = _decorator;

@observer
@ccclass('openSliverPop')
export default class openSliverPop extends Panel {

    static bundle = "openSliverPop";
    static skin = "openSliverPop";


    @property(Node) sliverThink: Node = null;
    @property(Node) sliverOpen1: Node = null;
    @property(Node) sliverOpen5: Node = null;
    @property(Node) x5: Node = null;


    onLoad() {
        this.sliverThink.on(Button.EventType.CLICK, this.clickThinkOpen)
        this.sliverOpen1.on(Button.EventType.CLICK, this.clickOpen1)
        this.sliverOpen5.on(Button.EventType.CLICK, this.clickOpen5)
    }

    start() {
        const {data = this.data} = this.data
        console.log(data, 112233)

        if (data == 1) {
            this.x5.active = false
            this.sliverOpen1.active = true
            this.sliverOpen5.active = false

        } else if (data == 5) {
            this.x5.active = true
            this.sliverOpen1.active = false
            this.sliverOpen5.active = true
        }
    }

    prizeVOList = {}
    list = []

    async clickThinkOpen() {
        hidePanel()
    }

    async clickOpen1() {
        const {success, data} = await sendWebNetWithToken(WebNetName.bagExchange, {drawType: 1, drawCount: 1})
        if (!success) return

        hidePanel();
        showPanel(GetPrize, data.prizeVOList)
    }

    async clickOpen5() {
        const {success, data} = await sendWebNetWithToken(WebNetName.bagExchange, {drawType: 1, drawCount: 5})
        if (!success) return

        hidePanel();
        showPanel(GetPrize, data.prizeVOList)
    }
}
