import { _decorator } from "cc";
import { foodPool } from "db://assets/Scripts/Scenes/MainGame/Manager/CommonPool";
import { PropBase } from "./PropBase";
import { Snake } from "db://assets/Scripts/Scenes/MainGame/Snake";

const { ccclass, property } = _decorator;

@ccclass("Food")
export class Food extends PropBase {

    _energy: number = 1;

    @property
    get energy() {
        return this._energy;
    }

    set energy(energy: number) {
        this._energy = energy;
        const scale = 1 + (energy - 1) / 3;
        this.node.scale.set(scale, scale);
    }

    onLoad() {
        super.onLoad();
    }

    init(energy: number = 1) {
        this.energy = energy;
    }

    beEaten = (target: Snake) => {
        target.addEnergy(this.energy);
    };

    recycle() {
        super.recycle();
        this.node.removeFromParent();
        foodPool.put(this.node);
    }

}