import { _decorator, Color, Component, Enum, Label, Node, Sprite, SpriteFrame } from "cc";
import { getUrlParams } from "./Utils/WebNet/web/webTools";
import Svga from "../Component/Svga/Svga";

const { ccclass, property, executeInEditMode, disallowMultiple, executionOrder } = _decorator;

enum ESkinType {
    Sprite,
    Label,
    Node,
}

Enum(ESkinType);

@ccclass("SkinNode")
class SkinNode {
    @property({
        type: Node,
        visible: function (this) {
            return this.type != ESkinType.Node;
        }
    }) node: Node = null;

    @property({ type: ESkinType }) type: ESkinType = ESkinType.Sprite;

    @property({
        type: Color,
        visible: function (this) {
            return this.type == ESkinType.Label;
        }
    }) color1: Color;

    @property({
        type: Color,
        visible: function (this) {
            return this.type == ESkinType.Label;
        }
    }) color2: Color;


    @property({
        type: SpriteFrame,
        visible: function (this) {
            return this.type == ESkinType.Sprite;
        }
    }) skin1: SpriteFrame = null;

    @property({
        type: SpriteFrame,
        visible: function (this) {
            return this.type == ESkinType.Sprite;
        }
    }) skin2: SpriteFrame = null;


    @property({
        type: Node,
        visible: function (this) {
            return this.type == ESkinType.Node;
        }
    }) node1: Node = null;

    @property({
        type: Node,
        visible: function (this) {
            return this.type == ESkinType.Node;
        }
    }) node2: Node = null;

}


@ccclass("AutoSkin")
@executeInEditMode
@executionOrder(-1)
@disallowMultiple()
export class AutoSkin extends Component {

    @property([SkinNode]) skinNodeArr: SkinNode[] = [];

    onLoad() {
        if (CC_EDITOR) return;
        const type = getUrlParams("type");

        if (+type == 1) {
            // 赵一鸣，红色版本
            this.skinNodeArr.forEach((skNode: SkinNode) => {
                if (skNode.node && skNode.type == ESkinType.Sprite && skNode.skin1) {
                    skNode.node.getComponent(Sprite).spriteFrame = skNode.skin1;
                } else if (skNode.node && skNode.type == ESkinType.Label && skNode.color1) {
                    skNode.node.getComponent(Label).color = skNode.color1;
                } else if (skNode.type == ESkinType.Node) {
                    skNode.node1.active = true;
                    skNode.node2.active = false;
                }

            });
        } else {
            // 零食很忙，黄色版本
            this.skinNodeArr.forEach((skNode: SkinNode) => {
                if (skNode.node && skNode.type == ESkinType.Sprite && skNode.skin2) {
                    skNode.node.getComponent(Sprite).spriteFrame = skNode.skin2;
                } else if (skNode.node && skNode.type == ESkinType.Label && skNode.color2) {
                    skNode.node.getComponent(Label).color = skNode.color2;
                } else if (skNode.type == ESkinType.Node) {
                    skNode.node1.active = false;
                    skNode.node2.active = true;
                }
            });
        }
    }

    @property
    private _genSkinNode = false;

    @property
    get genSkinNode() {
        return this._genSkinNode;
    }

    set genSkinNode(v) {
        this._genSkinNode = v;
        this.genNodeList();
    }

    genNodeList() {
        const loopList: Node[] = [this.node];

        const ids = this.skinNodeArr.map((skNode: SkinNode) => {
            return skNode.node.uuid;
        });

        while (loopList.length > 0) {
            const node = loopList[0];
            loopList.shift();

            if (!node.getComponent(Svga)) {
                loopList.unshift(...node.children);
            }

            if (ids.indexOf(node.uuid) > -1) return;

            if (node.getComponent(Sprite)) {
                const skNode = new SkinNode();
                skNode.node = node;
                skNode.type = ESkinType.Sprite;
                skNode.skin1 = node.getComponent(Sprite).spriteFrame;
                this.skinNodeArr.push(skNode);
            }

            if (node.getComponent(Label)) {
                const skNode = new SkinNode();
                skNode.node = node;
                skNode.type = ESkinType.Label;
                skNode.color1 = Color.clone(node.getComponent(Label).color);
                this.skinNodeArr.push(skNode);
            }
        }

    }

    start() {

    }

    update(deltaTime: number) {

    }
}


