import { QuadTreeNode } from "./QuadTreeNode";
import { Quadtree } from "./QuadTree";


// this.quadTree = new Quadtree({
//     x: 0, y: 0,
//     width: Global.MAP_WIDTH,
//     height: Global.MAP_HEIGHT,
// }, 25, 6

export function handleCollisions(quadTree: Quadtree) {
    // 使用四叉树进行碰撞检测
    for (const node of QuadTreeNode.caches) {

        if (!node.node.active) continue;
        const potentialCollisions = quadTree.retrieve(node);
        // 检查具体的碰撞
        for (const other of potentialCollisions) {
            if (node.intersects(other)) {
                // 处理碰撞
                node.emit(QuadTreeNode.EventType.COLLISION, node, other);
            }
        }
    }
}


export function updateQuadTree(quadTree: Quadtree) {
    // 清空四叉树
    quadTree.clear();

    // 重新插入所有节点
    for (const node of QuadTreeNode.caches) {
        if (node.node.active && node.enabled) {
            quadTree.insert(node);
        }
    }
    for (const node of QuadTreeNode.staticCaches) {
        if (node.node.active && node.enabled) {
            quadTree.insert(node);
        }
    }
}
