import { _decorator, IVec2Like, math, View } from "cc";

const { ccclass } = _decorator;

/**
 * 全局配置类
 */
@ccclass("Global")
export class Global {

    /** 地图宽度 */
    static MAP_WIDTH: number = 6000;

    /** 地图高度 */
    static MAP_HEIGHT: number = 4200;

    /** 道具CD */
    static PROP_CD: number = 15;


    static getRandomPosition(padding: number = 0): IVec2Like {
        const maxW = Global.MAP_WIDTH / 2 - padding;
        const maxH = Global.MAP_HEIGHT / 2 - padding;

        const x = math.randomRange(-maxW, maxW);
        const y = math.randomRange(-maxH, maxH);

        return { x, y };
    }

    static stageConfig = [
        {
            time: 10,
        },
        {
            time: 60,
            length: 50,
        }
    ];

}


export const SkinName = {
    "sp_decoration_default": "default",
    "sp_skin_snake_year": "newYear2025",
};
