import {
    _decorator,
    AssetManager,
    assetManager,
    Label, lerp,
    ProgressBar,
    resources,
} from "cc";
import Scene from "../../../Module/Scene";

const { ccclass, property } = _decorator;

@ccclass("GameLoading")
export class GameLoading extends Scene{

    static bundle = "GameLoading";
    static skin = "GameLoading";

    @property(ProgressBar)
    progressBar: ProgressBar;

    @property(Label)
    progressTxt: Label = null;

    onLoad() {

    }

    onDestroy() {

    }

    setProgress(progress: number) {
        this.progressBar.progress = progress;
        // this.progressTxt.string = `游戏加载中 ${Math.round(progress * 100)}%`;
    }


    async start() {
        this.setProgress(0.1);
        const pkg = [
            {
                path: "MainGame",
                type: "bundle"
            },
        ];
        const list = await this.getPreLoadList(pkg);

        await this.preload(list, 0.1, 1);

        this.data?.callBack();

    }

    getPreLoadList = async (pkg) => {
        const pathArr: {
            path: string;
            bundle: AssetManager.Bundle;
        }[] = [];

        const ps = [];

        pkg.forEach((asset) => {
            if (typeof asset == "string") {
                return pathArr.push({
                    path: asset,
                    bundle: resources,
                });
            }
            switch (asset.type) {
                case "dir":
                    resources.getDirWithPath(asset.path)
                        .forEach((v) => {
                            pathArr.push({
                                path: v.path,
                                bundle: resources
                            });
                        });
                    break;
                case "bundle":
                    ps.push(
                        new Promise<void>((resolve) => {
                            assetManager.loadBundle(asset.path, (err, bundle) => {
                                if (err) console.error(err);
                                bundle.getDirWithPath("").forEach((assets) => {
                                    pathArr.push({
                                        path: assets.path,
                                        bundle: bundle
                                    });
                                });
                                resolve();
                            });
                        })
                    );
                    break;

                default:
                    pathArr.push({
                        bundle: resources,
                        path: asset.path
                    });
            }
        });

        await Promise.all(ps);

        return pathArr;
    };

    preload = async (
        pkg: {
            path: string;
            bundle: AssetManager.Bundle
        }[],
        from = 0,
        to = 1
    ) => {
        const total = pkg.length;
        let loaded = 0;

        const ps = pkg.map((asset) => {
            return new Promise<void>((resolve) => {
                asset.bundle.load(asset.path, () => {
                    loaded++;
                    const progress = lerp(from, to, loaded / total);
                    this.setProgress(progress);
                    resolve();
                });
            });
        });

        await Promise.all(ps);
    };

}


