import { _decorator, Button, Component, Label, Node, Size, Sprite, } from 'cc';
import { observer, render } from '../store/decorators';
import Scene from '../../Module/Scene';
import { changeScene, hideWaiting, showWaiting } from '../../Module/UIFast';
import { _asyncThrottle, dateFormatter, strFormat } from '../Utils/Utils';
import { HomeScene } from './HomeScene';
import { sendWebNet, WebNetName } from '../Utils/WebNet/WebNet';
import { YXCollectionView, YXFlowLayout, YXIndexPath } from '../../Component/YXList/lib';
const { ccclass, property } = _decorator;

@observer
@ccclass('PointDetailScene')
export class PointDetailScene extends Scene {
  static bundle: string = "PointDetailScene";
  static skin: string = "PointDetailScene";


  @property(Node) backBtn: Node = null;

  @property(YXCollectionView) List: YXCollectionView = null;


  listData: any[] = [];

  onLoad() {

    this.backBtn.on(Button.EventType.CLICK, this.clickBackHome, this);
  }


  async start() {
    this.List.numberOfItems = () => this.listData.length;
    this.List.onCellDisplay = this.onListCellDisplay;

    const shengLayout = new YXFlowLayout();
    shengLayout.itemSize = new Size(1133, 50);
    this.List.layout = shengLayout;
    this.List.reloadData();

    showWaiting(true);
    await this.updateList()

    hideWaiting();

  }

  // 返回首页
  clickBackHome = _asyncThrottle(async () => {
    const{ifFrom}=this.data
    await changeScene(ifFrom, {isFrom: this.data.back});
  });

  // 数据更新
  async updateList() {
    const { success, data } = await sendWebNet(WebNetName.queryCredits);
    if (!success) return;

    this.listData = data.userCreditsRecord;
    this.List.reloadData();
    this.List.node.active = this.listData.length > 0;
  }

  onListCellDisplay = (cell: Node, indexPath: YXIndexPath, collectionView: YXCollectionView) => {
    const data = this.listData[indexPath.item];
    this.onCellDisplay(cell, data);
  }

  onCellDisplay = (cell: Node, data) => {
    let { type = 0, createTime = 0, score = 0, getWays = "" } = data;

    cell.getChildByName(`time`).getComponent(Label).string = dateFormatter(createTime, "yyyy.MM.dd hh:mm");

    cell.getChildByName(`source`).getComponent(Label).string = strFormat(getWays, 20);
    cell.getChildByName(`point_num`).getComponent(Label).string = type + score;
  }

}

