'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './inputinfomodal.less';
import { Toast } from '@grace/ui';
import API from '@/api';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import Selectmodal from '../selectmodal/selectmodal';
import store from '@/store/store';
// 定义 state 的类型
interface InputInfoModalState {
    name: string;
    phone: string;
    detail: string;
    province: string;
    city: string;
    area: string;
}
// 定义 props 的类型
interface InputInfoModalProps {
    id?: string; // 原代码中使用了 this.props?.id
    receiveSuc?: () => void; // 定义 receiveSuc 方法，可选类型
}
@observer
class Inputinfomodal extends React.Component<InputInfoModalProps, InputInfoModalState> {
    constructor(props) {
        super(props);
        this.state = {
            name: '',
            phone: '',
            detail: '',
            province: '',
            city: '',
            area: ''
        };
    }

    // handleChange = (field: keyof InputInfoModalState, value: string) => {
    //     this.setState({ [field]: value });
    // }

    // 指定 field 的类型为 InputInfoModalState 的键名
    handleChange = (field: keyof InputInfoModalState, value: string) => {
        // 这里使用类型断言确保类型匹配
        // this.setState({ [field]: value } as Pick<InputInfoModalState, typeof field>);
        store[field] = value
    }
    confirm = async () => {

        /**判空 */
        if (!store.name || !store.phone || !store.detail || !store.province || !store.city) {
            Toast.show("请输入完整信息")
            return
        }
        /**只判断11位手机号 */
        if (!/^1[3456789]\d{9}$/.test(store.phone)) {
            Toast.show("请输入正确的手机号")
            return
        }

        let { name, phone, detail, province, city, area } = store

        if (province == '北京市' || province == '上海市' || province == '天津市' || province == '重庆市') {
            city = province
        }

        const resp = await API.receivePrize({
            prizeRecordId: this.props?.id,
            collectUser: name,
            collectProvince: province,
            collectCity: city,
            collectAddr: detail,
            collectCounty: area,
            collectPhone: phone
        })
        if (resp.success) {
            Toast.show("领取成功")
            ModalCtrl.closeModal()
            // this.props?.receiveSuc && this.props?.receiveSuc()
            store.getPrizeList()
        } else {
            Toast.show("领取失败，请联系客服")
            ModalCtrl.closeModal()
        }
        // console.warn(this.state)
    }

    doSelect = ({ province, city, area }) => {
        console.log('doSelect 方法被调用，传入参数：', province, city, area);
        // this.setState({
        //     province,
        //     city,
        //     area
        // }, () => {
        //     console.log("选择地址后拿到的值", this.state.province, this.state.city, this.state.area);
        // });
        store.province = province
        store.city = city
        store.area = area
        // console.info(this.state)

    }

    select = () => {
        // modalStore.pushPop("Selectmodal", { doSelect: this.doSelect.bind(this) }, true)
        ModalCtrl.showModal(Selectmodal, { doSelect: this.doSelect.bind(this) })

    }


    render() {
        return (
            <div className="inputinfomodal modal_center">
                <span className="inputinfomodalclosebtn" onClick={() => {
                    ModalCtrl.closeModal()
                }}></span>
                <span className="inputinfomodalbg"></span>
                <span className="inputinfomodalconfirmbtn" onClick={() => {
                    this.confirm()
                }}></span>
                <div className="inputinfomodaldetailcon">
                    <span className="inputinfomodaldetailconbg"></span>
                    <input
                        type="text"
                        className="inputinfomodaldetailconplaceholder"
                        placeholder="请输入详细地址"
                        value={store.detail}
                        onChange={(e) => this.handleChange('detail', e.target.value)}
                    />
                </div>
                <div className="inputinfomodalphonecon">
                    <span className="inputinfomodalphoneconbg"></span>
                    <input
                        type="tel"
                        className="inputinfomodalphoneconplaceholder"
                        placeholder="请输入手机号"
                        value={store.phone}
                        onChange={(e) => this.handleChange('phone', e.target.value)}
                    />
                </div>
                <div className="inputinfomodalnamecon">
                    <span className="inputinfomodalnameconbg"></span>
                    <input
                        type="text"
                        className="inputinfomodalnameconplaceholder"
                        placeholder="请输入姓名"
                        value={store.name}
                        onChange={(e) => this.handleChange('name', e.target.value)}
                    />
                </div>
                <div className="inputinfomodalareacon" onClick={this.select.bind(this)}>
                    <span className="inputinfomodalareaconbg"></span>
                    <input
                        type="text"
                        className="inputinfomodalareaprovinceconplaceholder"
                        placeholder="请输入"
                        value={store.province}
                    // onChange={(e) => this.handleChange('province', e.target.value)}
                    />
                    <input
                        type="text"
                        className="inputinfomodalareacityconplaceholder"
                        placeholder="请输入"
                        value={store.city}
                    // onChange={(e) => this.handleChange('city', e.target.value)}
                    />
                    <input
                        type="text"
                        className="inputinfomodalareacountryconplaceholder"
                        placeholder="请输入"
                        value={store.area}
                        onChange={(e) => {
                            console.log(e.target.value)
                            // this.handleChange('area', e.target.value)
                        }
                        }
                    />
                </div>
            </div>
        );
    }
}
export default Inputinfomodal;
