import { Element } from "@/pages/GamePage/Components/Element/Element.ts";
import { Yeast } from "@/pages/GamePage/Components/Element/Yeast.ts";
import { Filiform } from "@/pages/GamePage/Components/Element/Filiform.ts";
import { Molecule } from "@/pages/GamePage/Components/Element/Molecule.ts";
import { Mugwort } from "@/pages/GamePage/Components/Element/Mugwort.ts";
import { Realgar } from "@/pages/GamePage/Components/Element/Realgar.ts";
import { ZongZi } from "@/pages/GamePage/Components/Element/ZongZi.ts";

export enum Ele {
  Yeast = "Yeast",  // 酵母菌
  Filiform = "Filiform",  // 丝状菌
  Molecule = "Molecule",  // 黄色分子
  Mugwort = "Mugwort", // 艾草
  Realgar = "Realgar", // 雄黄
  ZongZi = "ZongZi", // 雄黄
}

export interface EleData {
  cls: new () => Element,
  texture: string,
  weight: number,
  score?: number,
  neg?: boolean,
}

export const GameConfig = {
  gameCd: 120,
  magnetTime: 10000,
  magnetScale: 5,
  initEnergy: 10,
  growthThreshold: 2,
  levelCfg: [
    {
      score: 0,
      skin: "初级",
      level: 0,
    },
    {
      score: 30,
      skin: "红色",
      level: 1,
    },
    {
      score: 60,
      skin: "黄色",
      level: 2,
    },
    {
      score: 90,
      skin: "蓝色",
      level: 3,
    },
  ],
}

export const EleConfig: { [key in Ele]: EleData } = {
  [Ele.Yeast]: {
    cls: Yeast,
    texture: "元素/酵母菌.png",
    weight: 4,
    score: 1,
  },
  [Ele.Filiform]: {
    cls: Filiform,
    texture: "元素/丝状菌.png",
    weight: 3,
    score: 2,
  },
  [Ele.Molecule]: {
    cls: Molecule,
    texture: "元素/黄色分子.png",
    weight: 2,
    score: 3,
  },
  [Ele.Mugwort]: {
    cls: Mugwort,
    texture: "元素/艾草.png",
    weight: 1,
    score: -2,
    neg: true,
  },
  [Ele.Realgar]: {
    cls: Realgar,
    texture: "元素/雄黄.png",
    weight: 1,
    score: -2,
    neg: true,
  },
  [Ele.ZongZi]: {
    cls: ZongZi,
    texture: "元素/粽子.png",
    weight: 1,
  }
}

export const winSize = {
  width: 750,
  height: window.innerHeight / window.innerWidth * 750,
}

export const mapTop = 464;

export const mapSize = {
  width: winSize.width,
  height: winSize.height - mapTop,
}
