'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './prizepage.less';
import store from '@/store/store';
import { _asyncThrottle, miniGoUrl } from '@/utils/utils';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import Inputinfomodal from '@/components/inputinfomodal/inputinfomodal';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import { Button } from '@grace/ui';
import WxOpenModule from '@/components/wxOpenModule/wxOpenModule';
import { isWechatMiniProgram } from '@/AppTools';

@observer
class Prizepage extends React.Component {
  constructor(props) {
    super(props);
  }
  async componentDidMount() {
    await store.getPrizeList()
  }

  receive = _asyncThrottle((item) => {
    // modalStore.pushPop("Inputinfomodal", { item, receiveSuc: this.receiveSuc.bind(this) })
    ModalCtrl.showModal(Inputinfomodal, { ...item, receiveSuc: this.receiveSuc.bind(this) })
  })

  async receiveSuc() {
    await store.getPrizeList()
  }

  jumpUrl(item) {
    console.log('jumpUrl', item)
    // location.href = `/aaw/projectx/takePrize?projectOrderNo=${item.id}`;
    miniGoUrl('/pages/unify/unify?orgId=200282401019674482&targetUrl=%2Fpages%2Fcoupon%2Fcoupons-list')
  }
  back = () => {
    PageCtrl.backPage()
  }

  render() {
    return (
      <div className="prizepage modal_center">
        <span className="bg"></span>
        <div className="list" style={{ height: `${(1176 - (1624 - document.body.clientHeight * 750 / document.body.clientWidth) / 2) / 100}rem` }}>
          {
            store.prizeList.map((item, index) => {
              return (
                <div className="item" key={"prize" + index}>
                  <span className="itembg"></span>
                  {
                    item.boolThirdObject ? item.needFillAddress ? <Button className='bindbtn' onClick={() => this.receive(item)}></Button>
                      : <Button className='gotbtn' ></Button>
                      : <Button className='checkbtn' onClick={() => this.jumpUrl(item)}>
                        {
                          !isWechatMiniProgram() && <WxOpenModule
                            id={"prizebtn"}
                            appid={'wxc911dd6c6bc128de'}
                            username={'gh_de562905dee7'}
                            envVersion={'release'}
                            path={'/pages/unify/unify?orgId=200282401019674482&targetUrl=%2Fpages%2Fcoupon%2Fcoupons-list'}></WxOpenModule>
                        }

                      </Button>
                  }
                  <span className="name">{item.extra.name}</span>
                  <span className="prizeimg">
                    <img src={item.extra.icon} />
                  </span>
                </div>
              )
            })
          }
        </div>
        <span className="title"></span>
        {
          store.prizeList.length == 0 && <span className="empty"></span>
        }
        <Button className="back md38" onClick={this.back}></Button>
      </div>
    );
  }
}
export default Prizepage;
