'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './posterpop.less';

import QRCode from 'qrcode';
import html2canvas from 'html2canvas';
import API from '@/api';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
type PosterpopState = {
  codeImg: string;
  shareImg: string;
};
@observer
class Posterpop extends React.Component<{}, PosterpopState> {
  constructor(props) {
    super(props);
    this.state = {
      codeImg: '',
      shareImg: ''
    }
  }
  async componentDidMount() {
    const { success, data } = await API.getInviteCode();
    if (!success) { return }
    alert('公众号免登还没拼上 要记得加上')
    let url = location.origin + "/projectx/" + CFG.projectId + "/index.html?appID=" + CFG.appID + "&inviteCode=" + data.inviteCode;
    const qrcodeSrc = await QRCode.toDataURL(url);
    console.info(qrcodeSrc);
    this.setState({ codeImg: qrcodeSrc });

  }
  closePop(){
    ModalCtrl.closeModal()
  }
  render() {
    return (
      <div className="posterpop modal_center">
        <div className='back' onClick={this.closePop}></div>
        <div className="poster" id='poster'>
          <span className="posteriimg"></span>
          {
            this.state.codeImg && <img className='qrcode' src={this.state.codeImg} onLoad={() => {
              // 开始截图
              html2canvas(document.querySelector(".poster"), { useCORS: true }).then(canvas => {
                const base64 = canvas.toDataURL()
                console.info('html2canvas',base64)
                this.setState({
                  shareImg: base64
                })
              })
            }}></img>
          }

        </div>
        {
          this.state.shareImg && <img className='show' src={this.state.shareImg}></img>
        }
        <span className="tips"></span>
      </div>
    );
  }
}
export default Posterpop;
