import { logClick, logExposure, MDAuto } from "@grace/built-in";
import { IAutoMdData } from "@grace/built-in";
import {getUrlParam} from "@/utils/utils.ts";

const appId = CFG.appID;
const dcm = "202." + CFG.projectId + ".0.0";
const domain = "";

const channel = getUrlParam("channel");
const dom = `${channel}.0.0.0`;

const MDList: IAutoMdData[] = new Array(38).fill("").map((_, i) => {
  return {
    ele: `.md${i + 1}`,
    data: {
      dpm: `${appId}.110.${i + 1}.0`,
      dcm,
      dom,
      domain,
      appId,
    },
    once: false,
  };
});


MDAuto({
  show: MDList, // 曝光
  click: MDList, // 点击
});

export function handleLogExposure(id: number | string, id2: number | string = 0) {
  logExposure({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
  });
}

export function handleLogClick(id: number | string, id2: number | string = 0) {
  logClick({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
  });
}
