import { generateAPI } from "./utils"

const API = generateAPI({
  /** 获取活动规则 */
  getRule: 'projectRule.query',
  /** 获取前端配置项 */
  getFrontVariable: 'coop_frontVariable.query',
  // getShareInfo: '/wechatShare/getShareInfo/v2',
  getShareInfo: '/wechatMiniApp/ticket/info',
  /** 签到 */
  doSign: {
    uri: 'checkin_1/doSign.do',
    withToken: true,  // 携带token
  },

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },
  buriedPoint: {
    uri: "buriedPoint",
    showMsg: false,
  },
  records: "records.query",

  index: "tcs/index.do",
  submit: {
    uri: "tcs/submit.do",
    withToken: true,
    method: "post",
  },
  start: {
    uri: "tcs/start.do",
    withToken: true,
  },
  guide: "tcs/guide.do",
  rankInfo: 'tcs/rankIndex.do',
  drawIndex: 'draw/index.do',
  doDraw: {
    uri: 'draw/draw.do',
    withToken: true,
  },
  queryTasks: 'task_1/queryTasks.do',
  sendPrize: {
    uri: 'task_1/sendPrize.do',
    withToken: true,
  },
  getInviteCode: {
    uri: 'inviteAssist_1/getInviteCode.do',
    withToken: true,
    method: 'post',
  },
  doAssist: {
    uri: 'inviteAssist_1/doAssist.do',
    withToken: true,
    method: 'post',
  },
  getPrizeList: 'draw/myPrizeRecord.do',
  receivePrize: {
    uri: "draw/objectReceive.do",
    withToken: true,
    method: "post"
  },
  /** 获取地区 */
  getParentCode: "/gaw/address/getChildrenByParentCode",


})

// console.log('======', API)

export default API
