import React from "react";
import {observer} from "mobx-react";
import "./FailPanel.less";
import {Button} from "@grace/ui";
import {_asyncThrottle} from "@/utils/utils.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import PrizePanel from "@/panels/PrizePanel/PrizePanel.tsx";

@observer
class FailPanel extends React.Component {

  componentDidMount() {
  }

  clickCancel = () => {
    ModalCtrl.showModal(PrizePanel, {
      prizeVO: {  },
    });
  };

  clickAgain = _asyncThrottle(async () => {
    ModalCtrl.closeModal();
  });

  render() {
    return <div className="FailPanel">
      <div className="FailEffect"/>
      <div className="FailBg"/>

      <Button className="cancel md12" onClick={this.clickCancel}/>
      <Button className="again md13" onClick={this.clickAgain}/>
    </div>;
  }
}

export default FailPanel;
