import React, {HTMLAttributes} from "react";
import {observer} from "mobx-react";
import "./CompositePanel.less";
import {gsap} from "gsap";
import {SvgaPlayer} from "@grace/svgaplayer";

import bgSvga from "@/assets/svga/3输出宝箱动效.svga"
import effectSvga from "@/assets/svga/4打开光效.svga"
import posterSvga from "@/assets/svga/5输出刮卡.svga"
import {Button} from "@grace/ui";
import {globalMsg} from "@/pages/GamePage/event/MessageManager.ts";
import {GameEvent} from "@/pages/GamePage/GameEvent.ts";
import {ECard, ECardType} from "@/common.ts";
import musicStore from "@/store/musicStore.ts";
import collectPoster from "@/assets/music/收起海报.mp3";

export interface ICompositePanelProps extends HTMLAttributes<HTMLDivElement> {
  count: number,
  cardName: ECard,
}

@observer
class CompositePanel extends React.Component<ICompositePanelProps> {

  state = {
    showEffect: false,
    showPoster: false,
  }

  componentDidMount() {
    gsap.timeline({defaults: {ease: "sine.inOut"}})
      .set(".card1", {x: -100 * remScale})
      .to(".card1", {x: 0, scale: 1.1, duration: 0.666})
      .to(".card1", {scale: 1, duration: 0.333})
      .to(".card1", {x: 18 * remScale, duration: 0.333})
      .to(".card1", {x: 0, duration: 0.333})
      .to(".card1", {x: 18 * remScale, duration: 0.133})

    gsap.timeline({defaults: {ease: "sine.inOut"}})
      .set(".card2", {x: 100 * remScale})
      .to(".card2", {x: 0, scale: 1.1, duration: 0.666})
      .to(".card2", {scale: 1, duration: 0.333})
      .to(".card2", {x: -18 * remScale, duration: 0.333})
      .to(".card2", {x: 0, duration: 0.333})
      .to(".card2", {x: -18 * remScale, duration: 0.133})
      .call(() => {
        this.setState({showEffect: true});
        gsap.timeline({defaults: {ease: "sine.inOut"}})
          .delay(0.5)
          .to(".posterDiv", {scale: 1, duration: 0.333})
      });
  }

  onEnd = () => {

  }

  clickPosterBtn = () => {
    gsap.timeline({defaults: {ease: "sine.inOut"}})
      .to(".CompositePanel", {background: "rgba(0,0,0,0)", duration: 0.233})

    musicStore.playSound(collectPoster);

    gsap.timeline({defaults: {ease: "sine.inOut"}})
      .to(".CompositePanel", {
        x: -180 * remScale, y: 520 * remScale,
        scale: 0.1, duration: 0.5
      })
      .call(() => {
        globalMsg.emit(GameEvent.PosterClose);
      })
  }

  render() {

    const {count, cardName} = this.props;
    const {showEffect} = this.state;

    const card1Src = new URL(`../../../assets/Game/card/${cardName}${ECardType.A}.png`, import.meta.url).href;
    const card2Src = new URL(`../../../assets/Game/card/${cardName}${ECardType.B}.png`, import.meta.url).href;
    const posterSrc = new URL(`../../../assets/poster/${cardName}.png`, import.meta.url).href;

    return <div className="CompositePanel">
      <SvgaPlayer className="CompositeBg" src={bgSvga}/>
      <div className="CompositePanel_title">{count}碰</div>
      <img src={card1Src} className="card card1"/>
      <img src={card2Src} className="card card2"/>
      {showEffect && <SvgaPlayer
        className="CompositeEffect"
        src={effectSvga}
        loop={1}
        onEnd={this.onEnd}
      />}

      <div className="posterDiv" style={{
        transform: "scale(0)"
      }}>
        <img className="poster" src={posterSrc}/>
        <SvgaPlayer
          className="posterSvga"
          src={posterSvga}
          loop={1}
        />
        <Button className="posterBtn md11" onClick={this.clickPosterBtn}/>
      </div>
    </div>;
  }
}

export default CompositePanel;
