import React from "react";
import { observer } from "mobx-react";
import "./RulePanel.less";
import {Button} from "@grace/ui";
import store from "@/store/store.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";

@observer
class RulePanel extends React.Component {

  componentDidMount() {
    store.initRule();
  }

  close = () => {
    ModalCtrl.closeModal();
  };

  render() {
    return <div className="RulePanel modal_center">
      <div className="effect"/>
      <div className="ruleBg"/>
      <div className="content" dangerouslySetInnerHTML={{
        __html: store.ruleInfo,
      }}/>
      <Button className="close" onClick={this.close}/>
    </div>;
  }
}

export default RulePanel;
