import React from "react";
import { observer } from "mobx-react";
import "./PosterPanel.less";
import { Button } from "@grace/ui";
import { ECard } from "@/common.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";

export interface IPrizePanelProps {
  cardName: ECard,
}

@observer
class PosterPanel extends React.Component<IPrizePanelProps> {

  componentDidMount() {
  }

  clickPosterBtn = () => {
    ModalCtrl.closeModal();
  };

  render() {

    const { cardName } = this.props;

    const posterSrc = new URL(`../../assets/poster/${cardName}.png`, import.meta.url).href;

    return <div className="PosterPanel modal_center">
      <img className="poster" src={posterSrc}/>
      <Button className="posterBtn" onClick={this.clickPosterBtn}/>
    </div>;
  }
}

export default PosterPanel;
