import React from 'react';
import {observer} from 'mobx-react';
import './HomePage.less';
import {Button} from "@grace/ui";
import {_asyncThrottle} from "@/utils/utils.ts";
import store from "@/store/store.ts";
import {PAGE_MAP} from "@/utils/constants.ts";
import {SvgaPlayer} from "@grace/svgaplayer";
import homeSvga from "@/assets/svga/1输出首页氛围.svga";
import gameStore from "@/store/gameStore.ts";
import MusicBtn from "@/core/components/MusicBtn/MusicBtn.tsx";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import PrizePanel from "@/panels/PrizePanel/PrizePanel.tsx";
import RulePanel from "@/panels/RulePanel/RulePanel.tsx";

@observer
class HomePage extends React.Component<any, any> {

  root: HTMLDivElement;

  componentDidMount() {
    store.updateIndex();
  }

  /** 开始游戏按钮*/
  startGame = _asyncThrottle(async () => {

    if(!store.judgeActTime()) return;

    const suc = await gameStore.start();
    if (!suc) return;

    store.changePage(PAGE_MAP.GAME_PAGE);
  })

  /** 奖品按钮*/
  clickPrize = _asyncThrottle(() => {
    ModalCtrl.showModal(PrizePanel, {
      prizeVO: {  },
    });
  })

  /** 规则按钮*/
  clickRule = () => {
    ModalCtrl.showModal(RulePanel);
  }

  clickPoster = () => {
    if(!store.judgeActTime(true, false)) return;

    store.changePage(PAGE_MAP.POSTER_PAGE);
  }

  clickDraw = () => {
    if(!store.judgeActTime()) return;

    store.changePage(PAGE_MAP.DRAW_PAGE);
  }

  render() {

    const {remainTimes} = store.indexData

    return <div className="homeDemo" ref={(el) => this.root = el}>
      <div className="homeImg"/>
      <div className="bg"/>
      <div className="ip"/>
      {/*<div className="title"/>*/}
      <div className="smallTitle"/>

      <MusicBtn className="musicBtn md3"/>

      <Button className="prize md1" onClick={this.clickPrize}/>
      <Button className="rule md2" onClick={this.clickRule}/>
      <div className="cardBg"/>

      <SvgaPlayer className="homeSvga" src={homeSvga}/>
      <Button className="poster md4" onClick={this.clickPoster}/>
      <div className="numBg">
        剩余次数：{remainTimes}
      </div>
      <Button className="draw_icon" onClick={this.clickDraw}/>

      <Button className="starGame md5" onClick={this.startGame}/>
    </div>;
  }
}

export default HomePage;
