import {AnimatedSprite, Assets, Container, Sprite, Text} from "pixi.js";
import {globalMsg} from "@/pages/GamePage/event/MessageManager.ts";
import {GameEvent} from "@/pages/GamePage/GameEvent.ts";
import {ECard, ECardType} from "@/common.ts";


export type TCardInfo = {
  cardName: ECard;
  type: ECardType;
}


export class Card extends Container {

  private _type: ECardType = ECardType.A;

  set type(type: ECardType) {
    this._type = type;
  }

  get type(): ECardType {
    return this._type;
  }

  private _cardName: ECard = ECard.CARD_0;

  set cardName(cardName: ECard) {
    this._cardName = cardName;
  }

  get cardName(): ECard {
    return this._cardName;
  }

  sp: Sprite = null;
  selectImg: Sprite = null;
  effect: AnimatedSprite = null;

  private _select: boolean = false;

  set select(select: boolean) {
    this._select = select;
    this.selectImg.visible = select;
    this.effect.visible = select;
    if (select) {
      this.effect.gotoAndPlay(0);
    }
  }

  get select(): boolean {
    return this._select;
  }

  constructor(cardInfo: TCardInfo) {
    super();
    this.cardName = cardInfo.cardName;
    this.type = cardInfo.type;

    this.sp = new Sprite(Assets.get(`card/${this.cardName}${this.type}.png`));
    this.addChild(this.sp);


    this.selectImg = new Sprite(Assets.get("选中.png"));
    this.selectImg.visible = false;
    this.selectImg.position.set(-13, -18);
    this.addChild(this.selectImg);

    const textures = new Array(20).fill(1).map((_, i) => {
      return Assets.get(`选中效果/选中效果_${i}.png`);
    });
    this.effect = new AnimatedSprite(textures);
    this.addChild(this.effect);
    this.effect.loop = false;
    this.effect.animationSpeed = 0.5;
    this.effect.gotoAndPlay(0);
    this.effect.position.set(-46, -56);
    this.effect.stop();

    // const debugTxt = this.addChild(new Text({
    //   text: cardInfo.cardName,
    // }));
    // debugTxt.position.set(35, 50);
    // debugTxt.eventMode = "none";

    this.effect.eventMode = "none";
    this.selectImg.eventMode = "none";

    this.sp.on("touchstart", this.onTouchStart, this);

  }

  onTouchStart = () => {
    globalMsg.emit(GameEvent.ClickCard, this);
  }
}
