import React, {Component} from 'react'
import {observer} from "mobx-react";
import {createRoot} from "react-dom/client";
import store from "./store/store";

import "./core/checkwebp.ts";

import "./MD";

import {PAGE_MAP} from "./utils/constants";
import LoadingDemo from "./pages/LoadingDemo/LoadingDemo";
import HomePage from "@/pages/HomePage/HomePage.tsx";

import './App.less'
import '@csstools/normalize.css';
import GamePage from "@/pages/GamePage/GamePage.tsx";
import MyPrize from "@/pages/MyPrize/MyPrize.tsx";


const pageMap = {
  [PAGE_MAP.LOADING_PAGE]: <LoadingDemo/>,
  [PAGE_MAP.HOME_PAGE]: <HomePage/>,
  [PAGE_MAP.GAME_PAGE]: <GamePage/>,
  [PAGE_MAP.PRIZE_PAGE]: <MyPrize/>,
};

import bgm from "@/assets/music/bgm.mp3";
import musicStore from "@/store/musicStore.ts";
import {initWx} from "@/built-in/share/weixin/weixin.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";


@observer
class App extends Component {

  async componentDidMount() {
    musicStore.playSound(bgm, true);
    await store.getFrontVariable();
    initWx(store.frontVariable.shareInfo);
  }

  componentWillUnmount() {
  }

  render() {
    const {curPage, pageData} = store;
    return (
      <>
        {{...pageMap[curPage], props: {...pageData}}}
        <ModalCtrl/>
      </>
    );
  }
}

const root = createRoot(document.getElementById('root')!);
root.render(
  <App/>
);

