import { makeAutoObservable, } from 'mobx';
import API from '../api/index';
import { PAGE_MAP } from "../utils/constants";

import { GetCurrSkinId, getCustomShareId } from "../utils/utils";
import { Toast } from "@grace/ui";
import { IWxShareInfo } from "@/built-in/share/weixin/weixin.ts";

const skinId = GetCurrSkinId() || getCustomShareId();

class Store {

  constructor() {
    makeAutoObservable(this);
  }

  /** 前端开发配置 */
  frontVariable: {
    privacyTxt: string,
    prizeInfoAuthTxt: string,
    shareInfo: IWxShareInfo,
  } = {
    privacyTxt: "",
    prizeInfoAuthTxt: "",
    shareInfo: {
      title: "",
      desc: "",
      link: "",
      imgUrl: "",
    },
  };

  /** 当前页面 */
  curPage = {
    // TODO 举例子，自定义页面，因为mng更新原因原数字id会对应一个新的字符串id
    "5055": "sharePage",
    Did1NDA0NDc: "sharePage",

    myPrize: "myPrize", // TODO 举例子 新宿台奖品页
    index: PAGE_MAP.HOME_PAGE,
  }[skinId] || PAGE_MAP.HOME_PAGE;

  pageData = {};

  /** 场景切换 */
  changePage(page: PAGE_MAP, data = {}) {
    this.pageData = data;
    this.curPage = page;
  }

  ruleInfo = '';

  /** 获取活动规则 */
  async initRule() {
    // 模拟获取远程的数据
    const { data } = await API.getRule();
    this.ruleInfo = data;
  }

  /** 获取前端配置项 */
  async getFrontVariable() {
    // 获取前端开发配置
    const { data } = await API.getFrontVariable();
    this.frontVariable = data || {};
    console.log('前端开发配置', data)
  }

  indexData: {
    remainTimes?: number,
    uid?: string,
    endTime?: number,
    timeStamp?: number,
    startTime?: number,
  } = {};

  async updateIndex() {
    const { success, data, timeStamp } = await API.index();
    if (!success) {
      return;
    }
    this.indexData = data;
    this.indexData.timeStamp = timeStamp;
  }

  judgeActTime(brakeStart = true, brakeEnd = true) {
    if (brakeStart && this.indexData.timeStamp < this.indexData.startTime) {
      Toast.show("活动未开始，敬请期待");
      return false
    } else if (brakeEnd && this.indexData.timeStamp > this.indexData.endTime) {
      Toast.show("活动已结束");
      return false
    }
    return true;
  }

}

export default (new Store());
