/**
 * 检查是否支持.webp 格式图片
 * 支持 webp CDN   ?x-oss-process=image/format,webp
 * 不支持    CDN   ?x-oss-process=image/quality,Q_80
 */

(function () {
    let lowAdr = false;
    const ua = navigator.userAgent.toLowerCase()
    const isAndroid = ua.indexOf('android') > -1 || ua.indexOf('adr') > -1;
    if (isAndroid) {
        const ver = parseFloat(ua.substr(ua.indexOf('android') + 8, 3));
        lowAdr = ver < 4.4;
    }
    if (lowAdr && localStorage) {
        delete localStorage.isWebp;
    }
    if (localStorage && !localStorage.isWebp) {
        const img = new Image()
        img.onload = function () {
            if (img.width === 1 && !lowAdr) {
                localStorage.isWebp = true;
                document.getElementsByTagName('html')[0].setAttribute('duiba-webp', 'true')
            } else {
                localStorage.isWebp = '';
            }
        }
        img.onerror = function () {
            localStorage.isWebp = ''
        }
        img.src = 'data:image/webp;base64,UklGRiQAAABXRUJQVlA4IBgAAAAwAQCdASoBAAEAAwA0JaQAA3AA/vuUAAA='
    }
})();


export const webpQuery = "?x-oss-process=image/format,webp";

export function supportWebp() {
    return !!localStorage?.isWebp;
}