'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './drawprizepop.less';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import Prizepage from '@/pages/prizepage/prizepage';

type DrawprizepopProps = {
  optionImg: string;
  optionName: string;
}
@observer
class Drawprizepop extends React.Component<DrawprizepopProps> {
  constructor(props) {
    super(props);
  }
  goPrize = () => {
    ModalCtrl.closeModal();
    PageCtrl.changePage(Prizepage);
  }
  closePop = () => {
    ModalCtrl.closeModal();
  }
  render() {
    return (
      <div className="drawprizepop modal_center">
        <span className="bg"></span>
        <span className="prizelight"></span>
        <span className="prizieimg">
          <img src={this.props.optionImg}></img>
        </span>
        <span className="prizename">{this.props.optionName}</span>
        <span className="tips">奖品可在首页 我的奖品 中查看</span>
        <span className="close" onClick={this.closePop}></span>
        <span className="btn" onClick={this.goPrize}></span>
      </div>
    );
  }
}
export default Drawprizepop;
