'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './rankprizepop.less';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import Prizepage from '@/pages/prizepage/prizepage';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button } from '@grace/ui';
type RankprizepopProps = {
  prizeImg: string;
  prizeName: string;
  rank: number;
};
@observer
class Rankprizepop extends React.Component<RankprizepopProps> {
  constructor(props) {
    super(props);
  }
  goPrize = () => {
    ModalCtrl.closeModal();
    PageCtrl.changePage(Prizepage);
  }
  closePop = () => {
    ModalCtrl.closeModal();
  }
  render() {
    return (
      <div className="rankprizepop modal_center">
        <span className="bg"></span>
        <div className="prizeitem">
          <span className="prizelight"></span>
          <span className="prizeimg">
            <img
              src={this.props.prizeImg}
              alt="" />
          </span>
        </div>
        <span className="name">{this.props.prizeName}</span>
        <span className="ranklab">最终排名为{this.props.rank}</span>
        <span className="tips">奖品可在首页 我的奖品 中查看</span>
        <Button className="close md36" onClick={this.closePop}></Button>
        <Button className="btn md35" onClick={this.goPrize}></Button>
      </div>
    );
  }
}
export default Rankprizepop;
