import React from 'react';
import { observer } from 'mobx-react';
import './GuidePage.less';
import { SvgaPlayer } from "@grace/svgaplayer";

import kuang from "../../assets/GuidePage/4输出横幅效果.svga";
import { SvgaPlayerRef } from "@grace/svgaplayer/dist/components/SvgaPlayer";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import GamePage from "@/pages/GamePage/GamePage.tsx";
import { Button } from "@grace/ui";
import API from "@/api";

@observer
class GuidePage extends React.Component<any, any> {

  state = {
    guide: 1,
    canNext: false,
  }

  kuangSvga: SvgaPlayerRef;


  componentDidMount() {
    setTimeout(() => {
      this.setState({ canNext: true });
    }, 2000);
  }

  next = () => {
    const { guide, canNext } = this.state;
    if (guide >= 6) return;

    if (!canNext) return;
    this.setState({ guide: guide + 1, canNext: false });
    setTimeout(() => {
      this.setState({ canNext: true });
    }, 1666);

    this.kuangSvga.start();
  }

  onEnd = () => {
    // this.setState({ canNext: true });
  }

  startGame = () => {
    API.guide();
    PageCtrl.changePage(GamePage);
  }

  render() {
    const { guide, canNext } = this.state;
    return <div className="GuidePage" onClick={this.next}>
      <div className="bg"/>

      {guide < 6 && <SvgaPlayer
        ref={(el) => (this.kuangSvga = el)}
        onEnd={this.onEnd}
        src={kuang}
        className={`kuang kuang${guide}`}
        loop={1}
      />}

      {guide == 1 && <div className="guide guide1"/>}
      {guide == 2 && <div className="guide guide2"/>}
      {guide == 3 && <div className="guide guide3"/>}
      {guide == 4 && <div className="guide guide4"/>}
      {guide == 5 && <div className="guide guide5"/>}
      {guide >= 6 && <div className="guide6">
        <Button className="guide6Btn" onClick={this.startGame}/>
      </div>}

      {guide == 1 && <div className="joystick"/>}
      {guide < 6 && canNext && <div className="tip">点击屏幕继续</div>}

    </div>;
  }
}

export default GuidePage;
