import React from "react";
import { observer } from "mobx-react";
import "./PrizePanel.less";
import { Button } from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import FailPanel from "@/panels/FailPanel/FailPanel.tsx";


export interface IPrizePanelProps {
  prizeVO: {
    prizeId: string | "thanks",
    prizeName: string,
    prizeImg: string,
  },
  remainGameTimes: number,
}

@observer
class PrizePanel extends React.Component<IPrizePanelProps> {

  componentDidMount() {
  }

  close = () => {
    ModalCtrl.closeModal();
  };

  clickGet = () => {
    ModalCtrl.showModal(FailPanel);
  };


  render() {

    const { prizeVO } = this.props;

    return <div className="PrizePanel">
      <div className="PrizeBg"/>
      <img className="prizeImg" src={prizeVO.prizeImg}/>
      <div className="prizeName">{prizeVO?.prizeName}</div>

      <Button className="ok md18" onClick={this.clickGet}/>
      <Button className="close" onClick={this.close}/>
    </div>;
  }

}

export default PrizePanel;
