import {generateAPI} from "./utils"

const API = generateAPI({
  /** 获取活动规则 */
  getRule: 'projectRule.query',
  /** 获取前端配置项 */
  getFrontVariable: 'coop_frontVariable.query',
  // getShareInfo: '/wechatShare/getShareInfo/v2',
  getShareInfo: '/wechatMiniApp/ticket/info',
  /** 签到 */
  doSign: {
    uri: 'checkin_1/doSign.do',
    withToken: true,  // 携带token
  },

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },

  records: "records.query",

  index: "home/index.do",
  submit: {
    uri: "home/submit.do",
    withToken: true,
  },
  start: {
    uri: "home/start.do",
    withToken: true,
  },

})

// console.log('======', API)

export default API
